/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLogEventsContentProvider.java,v 1.4 2005/10/14 15:26:03 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.util;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;

/**
 * This is the content provider used by TPTP Test Log Viewer Events tree.
 * 
 * @author bjiang
 * @author marcelop
 * @since  4.1
 */
public class TestLogEventsContentProvider extends EObjectTreeContentProvider
{
	public TestLogEventsContentProvider(EStructuralFeature eStructuralFeature)
	{
		super(eStructuralFeature);
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.util.EObjectContainerContentProvider#getRegisteredParentChild(java.lang.Object)
	 */
	protected Object getRegisteredParentChild(Object parent)
    {
        if(parent instanceof TPFExecutionResult)
        {
            TPFExecutionResult executionResult = (TPFExecutionResult)parent;
            if(executionResult.getExecutionHistory() != null)
                return executionResult.getExecutionHistory().getExecutionEvents();
            return null;
        }
        //added to set the parent/child hierarchy for execution events :BGB(12/2/03)
        else if (parent instanceof TPFExecutionEvent)
        {
            if ( parent instanceof TPFInvocationEvent )
            {
                TPFInvocationEvent invocationEvent  = (TPFInvocationEvent)parent;
                return( invocationEvent.getInvokedExecutionResult() );
            }
            else
            {
                TPFExecutionEvent   executionEvent  = (TPFExecutionEvent)parent;
                if ( ( executionEvent.getChildren() != null ) &&
                     ( executionEvent.getChildren().isEmpty() == false ))
                    return( executionEvent.getChildren());
            }
        }
        return super.getRegisteredParentChild(parent);
    }
    
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
    public Object getParent(Object element)
    {
        if(element instanceof TPFExecutionResult)
        {
            TPFExecutionResult executionResult = (TPFExecutionResult)element;
            if(executionResult.getInvocationExecutionEvent() != null)
                return executionResult.getInvocationExecutionEvent();
        }
        //added to set the parent/child hierarchy for execution events :BGB(12/2/03)
        else if (element instanceof TPFExecutionEvent)
        {
            TPFExecutionEvent executionEvent    = (TPFExecutionEvent)element;
            if (executionEvent.eContainer() instanceof TPFExecutionHistory)
            {
				//- added to return the TPFExecutionResult in case the eContainer is a TPFExecutionHistory
				TPFExecutionHistory exhis = (TPFExecutionHistory)executionEvent.eContainer();
				TPFExecutionResult exres = exhis.getExecutionResult();
				if (exres.eContainer() == null) return exhis;
				else return exhis.getExecutionResult();
            }
            else 
                return( executionEvent.eContainer());
        }
        
        return super.getParent(element);
    }

	/*public Object[] getChildren(Object parent)
	{
		if(parent instanceof TPFExecutionResult)
        {
            TPFExecutionResult executionResult = (TPFExecutionResult)parent;
            if(executionResult.getExecutionHistory() != null)
                return executionResult.getExecutionHistory().getExecutionEvents().toArray();
        }
        //added to set the parent/child hierarchy for execution events :BGB(12/2/03)
        else if (parent instanceof TPFExecutionEvent)
        {
            if ( parent instanceof TPFInvocationEvent )
            {
                TPFInvocationEvent invocationEvent = (TPFInvocationEvent)parent;
                return new Object[]{invocationEvent.getInvokedExecutionResult()};
            }
            else
            {
                TPFExecutionEvent executionEvent = (TPFExecutionEvent)parent;
                if ( (executionEvent.getChildren() != null ) &&
                     (executionEvent.getChildren().isEmpty() == false))
                    return executionEvent.getChildren().toArray();
            }
        }
		return new Object[0];
	}*/
}
