/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLogVerdictCollection.java,v 1.9 2007/06/04 13:58:48 jptoomey Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictList;

/**
 * This class is 
 * 
 * @author bjiang
 * @since  4.1
 */
public class TestLogVerdictCollection implements ITestLogVerdictTraversal
{
	
	/**
	 * @deprecated As of TPTP V4.4.0, use {@link ITestLogVerdictTraversal#VERDICT_TYPE_ALL}.
	 */
	public static final int VERDICT_TYPE_ALL = ITestLogVerdictTraversal.VERDICT_TYPE_ALL;
	
	private TPFExecutionResult execResult;
	private Hashtable verdictLists;
	
	public TestLogVerdictCollection(TPFExecutionResult result) 
	{
		this.execResult = result;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal#contains(int)
	 */
	public boolean contains(int verdictType)
	{
		return getVerdictLists().get(new Integer(verdictType)) == null ? false : true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal#hasPrevious(int, java.lang.Object)
	 */
	public boolean hasPrevious(int verdictType, Object current)
	{
		return getPrevious(verdictType, current) == null ? false : true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal#hasNext(int, java.lang.Object)
	 */
	public boolean hasNext(int verdictType, Object current)
	{
		return getNext(verdictType, current) == null ? false : true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal#getFirst(int)
	 */
	public TPFVerdictEvent getFirst(int verdictType)
	{
		List verdicts = (List)getVerdictLists().get(new Integer(verdictType));
		if(verdicts != null)
			return (TPFVerdictEvent)verdicts.get(0);
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal#getLast(int)
	 */
	public TPFVerdictEvent getLast(int verdictType)
	{
		List verdicts = (List)getVerdictLists().get(new Integer(verdictType));
		if(verdicts != null)
			return (TPFVerdictEvent)verdicts.get(verdicts.size() - 1);
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal#getNext(int, java.lang.Object)
	 */
	public TPFVerdictEvent getNext(int verdictType, Object current)
	{
		if(current == null)
			return getFirst(verdictType);
		else if(current instanceof TPFVerdictEvent)
			return getNextVerdict(verdictType, (TPFVerdictEvent)current);
		else
			return getNextVerdict(verdictType, current);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal#getPrevious(int, java.lang.Object)
	 */
	public TPFVerdictEvent getPrevious(int verdictType, Object current)
	{
		if(current == null)
			return getLast(verdictType);
		else if(current instanceof TPFVerdictEvent)
			return getPreviousVerdict(verdictType, (TPFVerdictEvent)current);
		else
			return getPreviousVerdict(verdictType, current);
	}
	
	protected TPFVerdictEvent getPreviousVerdict(int verdictType, TPFVerdictEvent current)
	{
		if(verdictType == VERDICT_TYPE_ALL || current.getVerdict().getValue() == verdictType)
		{
			List verdicts = (List)getVerdictLists().get(new Integer(verdictType));
			if(verdicts != null)
			{
				int index = verdicts.indexOf(current);
					if(index > 0)
						return (TPFVerdictEvent)verdicts.get(index - 1);
			}
		}
		else
		{
			List verdicts = (List)getVerdictLists().get(new Integer(VERDICT_TYPE_ALL));
			if(verdicts != null)
			{
				int index = verdicts.indexOf(current);
				if(index > 0)
				{
					for(int i = (index - 1); i > -1; i--)
					{
						TPFVerdictEvent event = (TPFVerdictEvent)verdicts.get(i);
						if(event.getVerdict().getValue() == verdictType)
							return event;
					}
				}
			}
		}
		return null;
	}
	
	protected TPFVerdictEvent getPreviousVerdict(int verdictType, Object current)
	{
		TPFVerdictEvent verdict = null;
		Object parent = getParent(current);
		while(parent != null)
		{
			int index = getChildIndex(parent, current);
			verdict = searchPreviousVerdictInChildren(verdictType, parent, index);
			if(verdict != null)
				return verdict;
			current = parent;
			parent = getParent(current);
		}
		
		return null;
	}
	
	/**
	 * Search for a <code>TPFVerdictEvent</code> of the specified type among all the nested children of <i>parent</i>
	 * starting after <i>index</i>.
	 */
	protected TPFVerdictEvent searchPreviousVerdictInChildren(int verdictType, Object parent, int index)
	{
		Object[] children = getChildren(parent);
		index = (index == -1) ? children.length : index;
		for(int i = (index - 1); i > -1; i--)
		{			
			if(children[i] instanceof TPFVerdictEvent)
			{
				if(verdictType == VERDICT_TYPE_ALL)
					return (TPFVerdictEvent)children[i];
				if(((TPFVerdictEvent)children[i]).getVerdict().getValue() == verdictType)
					return (TPFVerdictEvent)children[i];
			}
			TPFVerdictEvent verdict = searchPreviousVerdictInChildren(verdictType, children[i], -1);
			if(verdict != null)
				return verdict;
		}
		
		return null;
	}
	
	protected TPFVerdictEvent getNextVerdict(int verdictType, TPFVerdictEvent current)
	{
		if(verdictType == VERDICT_TYPE_ALL || current.getVerdict().getValue() == verdictType)
		{
			List verdicts = (List)getVerdictLists().get(new Integer(verdictType));
		if(verdicts != null)
		{
			int index = verdicts.indexOf(current);
				if((index + 1) < verdicts.size())
					return (TPFVerdictEvent)verdicts.get(index + 1);
		}
		}
		else
		{

			List verdicts = (List)getVerdictLists().get(new Integer(VERDICT_TYPE_ALL));
			if(verdicts != null)
			{
				int index = verdicts.indexOf(current);
				if(index + 1 < verdicts.size())
				{
					for(int i = (index + 1); i < verdicts.size(); i++)
					{
						TPFVerdictEvent event = (TPFVerdictEvent)verdicts.get(i);
						if(event.getVerdict().getValue() == verdictType)
							return event;
					}
				}
			}
		}
		return null;
	}
	
	protected TPFVerdictEvent getNextVerdict(int verdictType, Object current)
	{
		TPFVerdictEvent verdict = searchNextVerdictInChildren(verdictType, current, -1);
		if(verdict != null)
			return verdict;
		
		Object parent = getParent(current);
		while(parent != null)
		{
			int index = getChildIndex(parent, current);
			verdict = searchNextVerdictInChildren(verdictType, parent, index);
			if(verdict != null)
				return verdict;
			current = parent;
			parent = getParent(current);
		}
		
		return null;
	}
	
	protected int getChildIndex(Object parent, Object child)
	{
		Object[] children = getChildren(parent);
		for(int i = 0; i < children.length; i++)
		{			
			if(children[i].equals(child))
			{
				return i;
			}
		}
		return -1;
	}
	
	/**
	 * Search for a <code>TPFVerdictEvent</code> of the specified type among all the nested children of <i>parent</i>
	 * starting after <i>index</i>.
	 */
	protected TPFVerdictEvent searchNextVerdictInChildren(int verdictType, Object parent, int index)
	{
		Object[] children = getChildren(parent);
		for(int i = index + 1; i < children.length; i++)
		{			
			if(children[i] instanceof TPFVerdictEvent)
			{
				if(verdictType == VERDICT_TYPE_ALL)
					return (TPFVerdictEvent)children[i];
				if(((TPFVerdictEvent)children[i]).getVerdict().getValue() == verdictType)
					return (TPFVerdictEvent)children[i];
			}
			TPFVerdictEvent verdict = searchNextVerdictInChildren(verdictType, children[i], -1);
			if(verdict != null)
				return verdict;
		}
		
		return null;
	}
	
	public Object[] getChildren(Object parent)
	{
		if(parent instanceof TPFExecutionHistory)
		{
			return ((TPFExecutionHistory)parent).getExecutionEvents().toArray();
		}
		if(parent instanceof TPFExecutionResult)
        {
            TPFExecutionResult executionResult = (TPFExecutionResult)parent;
            if(executionResult.getExecutionHistory() != null)
                return executionResult.getExecutionHistory().getExecutionEvents().toArray();
        }
        //added to set the parent/child hierarchy for execution events :BGB(12/2/03)
        else if (parent instanceof TPFExecutionEvent)
        {
            if ( parent instanceof TPFInvocationEvent )
            {
                TPFInvocationEvent invocationEvent = (TPFInvocationEvent)parent;
                return new Object[]{invocationEvent.getInvokedExecutionResult()};
            }
            else
            {
                TPFExecutionEvent executionEvent = (TPFExecutionEvent)parent;
                if ( (executionEvent.getChildren() != null ) &&
                     (executionEvent.getChildren().isEmpty() == false))
                    return executionEvent.getChildren().toArray();
            }
        }
		return new Object[0];
	}
	
	protected Object getParent(Object element)
	{
		if(element instanceof TPFExecutionResult)
        {
            TPFExecutionResult executionResult = (TPFExecutionResult)element;
            if(executionResult.getInvocationExecutionEvent() != null)
                return executionResult.getInvocationExecutionEvent();
        }
        //added to set the parent/child hierarchy for execution events :BGB(12/2/03)
        else if (element instanceof TPFExecutionEvent)
        {
            TPFExecutionEvent executionEvent    = (TPFExecutionEvent)element;
            if (executionEvent.eContainer() instanceof TPFExecutionHistory)
            {
				//- added to return the TPFExecutionResult in case the eContainer is a TPFExecutionHistory
				TPFExecutionHistory exhis = (TPFExecutionHistory)executionEvent.eContainer();
				TPFExecutionResult exres = exhis.getExecutionResult();
				if (exres.eContainer() == null) return exhis;
				else return exhis.getExecutionResult();
            }
            else 
                return( executionEvent.eContainer());
        }
		
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal#getExecutionResult()
	 */
	public TPFExecutionResult getExecutionResult()
	{
		return this.execResult;
	}
	
	synchronized protected void collectVerdicts(TPFExecutionResult result) {
		verdictLists = new Hashtable();
		List lists = result.getVerdictLists();
		TPFVerdictList verdictList = null;
		int type;
		List verdictEvents = null;
		for(Iterator it = lists.iterator(); it.hasNext();)
		{
			verdictList = (TPFVerdictList)it.next();
			verdictEvents = verdictList.getVerdictEvents();
			if(verdictEvents != null && !verdictEvents.isEmpty())
			{
				if(TPFVerdictList.VERDICT_TYPE_ALL.equals(verdictList.getType()))
					verdictLists.put(new Integer(VERDICT_TYPE_ALL), verdictEvents);
				else
				{
					type = ((TPFVerdictEvent)verdictEvents.get(0)).getVerdict().getValue();
					verdictLists.put(new Integer(type), verdictEvents);
				}
			}
		}
		
		
		//collectVerdicts(result.getExecutionHistory().getExecutionEvents());
	}
	
	/*protected void collectVerdicts(List executionEvents) {
		Iterator it = executionEvents.iterator();
		while (it.hasNext()) {
			TPFExecutionEvent event = (TPFExecutionEvent) it.next();

			if (event instanceof TPFInvocationEvent) {				
				TPFInvocationEvent iEvent = (TPFInvocationEvent) event;
				TPFExecutionResult result = iEvent.getInvokedExecutionResult();
				collectVerdicts(result);
				
			} else if (event instanceof TPFVerdictEvent) {
				TPFVerdictEvent vEvent = (TPFVerdictEvent)event;
				
				// populate verdictListsByType
				addVerdictEvent(vEvent.getVerdict().getValue(), vEvent);
				addVerdictEvent(VERDICT_TYPE_ALL, vEvent);				
			} else {
				collectVerdicts(event.getChildren());
			}
		}
	}
	
	protected void addVerdictEvent(int type, TPFVerdictEvent event)
	{
		Integer iType = new Integer(type);
		List verdicts = (List)getVerdictLists().get(iType);
		if(verdicts == null)
		{
			verdicts = new ArrayList();
			getVerdictLists().put(iType, verdicts);
		}
		verdicts.add(event);
	}*/
	
	protected Hashtable getVerdictLists()
	{
		if(verdictLists == null)
		{
			verdictLists = new Hashtable();
			// optimize performance, do initial collection when the list is first queried.
			collectVerdicts(execResult);
		}
		return verdictLists;
	}
	
	/*
	public void run()
	{
		EObject objectSelection = (EObject)getStructuredSelection().getFirstElement();
        EObject parent = (EObject)getLogEventsContentProvider().getParent(objectSelection);
        int childIndex =  -1;
        if (parent instanceof TPFExecutionHistory) {
            parent=(EObject)((TPFExecutionHistory)parent).getExecutionResult();
        }
        childIndex = getChildIndex(parent,objectSelection);
        Object nextFail = checkAllChildren(objectSelection);
        if (nextFail!=null) {
            StructuredSelection newSelection = new StructuredSelection(nextFail);
            getStructuredViewer().setSelection(newSelection, true);
        } else {
            nextFail = getVerdictEvent(parent,childIndex);
            if (nextFail!=null) {
                StructuredSelection newSelection = new StructuredSelection(nextFail);
                getStructuredViewer().setSelection(newSelection, true);
            }
        }
        if (nextFail==null) {
            while (!(parent instanceof TPFExecutionResult)) {
                parent = (EObject)getLogEventsContentProvider().getParent(parent);
                if (parent == null) {
                    return;
                }
            }
            TPFExecutionResult er = (TPFExecutionResult)parent;
            if (!hasFail(er)) {
                return;
            }
            nextFail = getVerdictEvent(er.getExecutionHistory().getExecutionEvents().get(0),-1);
            StructuredSelection newSelection = new StructuredSelection(nextFail);
            getStructuredViewer().setSelection(newSelection, true);            
        }
    }
	
	public boolean hasFail(TPFExecutionResult er) {
        if (getVerdictEvent(er.getExecutionHistory().getExecutionEvents().get(0),-1)!=null) {
            return true;
        }
        return false;
    }
    
    protected Object getVerdictEvent(Object parent, int childIndex) {
        Object[] children = getLogEventsContentProvider().getChildren(parent);
        for (int i = childIndex+1; i < children.length; i++) {
            Object child = children[i];
            if (child instanceof TPFVerdictEvent 
                    && ( ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.FAIL
                    || ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.ERROR) ) {
                return child;
            } else {
                Object returnObject = checkAllChildren(child);
                if (returnObject!=null) {
                    return returnObject;
                }
            }
        }
        EObject currentParent = (EObject)getLogEventsContentProvider().getParent(parent);
        if (currentParent==null) {
            return null;
        } else {
            if (currentParent instanceof TPFExecutionHistory) {
                currentParent=(EObject)((TPFExecutionHistory)currentParent).getExecutionResult();
            }
            childIndex = getChildIndex(currentParent,parent);
            Object fail = getVerdictEvent(currentParent,childIndex);
            if (fail!=null) {
                return fail;
            }
        }
        return null;
    }
    
    public Object checkAllChildren(Object parent){
        Object[] children = getLogEventsContentProvider().getChildren(parent);
        for (int i = 0; i < children.length; i++) {
            Object child = children[i];
            if (child instanceof TPFVerdictEvent 
            && ( ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.FAIL
            || ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.ERROR) ) {
                return child;
            } else {
                Object returnObject = checkAllChildren(child);
                if (returnObject!=null) {
                    return returnObject;
                }
            }
        }
        return null;
    }
    
    protected int getChildIndex(Object parent, Object child) {
        Object[] children = getLogEventsContentProvider().getChildren(parent);
        for (int i = 0; i < children.length; i++) {
            if (children[i].equals(child)) {
                return i;
            }
        }
        return -1;
	}*/
}
