/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddDatapoolAction.java,v 1.5 2007/03/22 14:42:05 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import java.io.File;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTableSection;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;


/**
 * This IAction adds a datapool to a table.
 * @author bcormier
 * @since 3.0.0
 */
public class AddDatapoolAction extends AddTestSuiteChildAction {
    private TPFTestSuite testSuite;
    private ExtensibleEObjectTableSection table;
    
    /**
     * Constructor for the class.
     * @param text The label for the button.
     */
    public AddDatapoolAction() {
        super(UiPluginResourceBundle.label_Add); 
    }
    
    /**
     * @see org.eclipse.ui.actions.BaseSelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection) {
		if (selection == null) 
			return false;
		
		// We need to store the test context
		TPFTestSuite tmp = getTestSuite(selection);
		if (tmp != null)
		    testSuite = tmp;
		if (testSuite == null)
			return false;

		return true;
    }
    
    /**
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run() {
		
        if (testSuite == null)
		    return;
		
        // Launch a file dialog
		Shell shell = Display.getCurrent().getActiveShell();
		FileDialog fd = new FileDialog(shell);
		fd.setFilterExtensions(new String[] {"*.datapool", "*.*"}); //$NON-NLS-1$ //$NON-NLS-2$
		fd.open();

		// Get the selected datapool file
		Path datapoolPath = new Path(fd.getFilterPath() + IPath.SEPARATOR + fd.getFileName());
		File file = datapoolPath.toFile();
		if (file==null || !file.exists())
		    return;
		
		// Extract the datapool from the file
		Common_DatapoolFactoryImpl factory = new Common_DatapoolFactoryImpl();
		DPLDatapool dataPool = (DPLDatapool)factory.loadForEdit(file, false);
		if (testSuite.getDatapools()==null)
		    return;
		
		// Add the datapool to the test context and refresh the table
		if (! testSuite.getDatapools().contains(dataPool))
		    testSuite.getDatapools().add(dataPool);
		table.initialize(testSuite);
    }

    /**
     * @param table The table to set.
     */
    public void setTable(ExtensibleEObjectTableSection table) {
        this.table = table;
    }
}
