/********************************************************************** 
 * Copyright (c) 2003, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: AddEquivalenceClassAction.java,v 1.4 2007/05/03 01:42:20 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;

/**
 * This class handles <i>Add</i> action in datapool editor to add a new
 * <i>equivalence class</i>.
 * 
 * @author bjiang
 * @since  3.3
 */
public class AddEquivalenceClassAction extends DatapoolEquivalenceClassSelectionAction {
	
    
	/**
	 * Creates an instance of this class that refreshes with the editor object.
	 * 
	 * @param editorExtension
	 * @param text
	 */
	public AddEquivalenceClassAction(DatapoolEditorExtension editorExtension, String text) {
		super(editorExtension, text);
	}
	
    /* (non-Javadoc)
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run()
    {
        IDatapoolEquivalenceClass eqCls = getParent().constructEquivalenceClass();
        // TODO insert after selection. 
        //if(index > -1 && (index < (getParent().getEquivalenceClassCount() - 1)))
            //getParent().insertEquivalenceClass(eqCls, (index + 1));
        //else
            getParent().appendEquivalenceClass(eqCls);

        eqCls.appendRecord(eqCls.constructRecord());
	}
}
