/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddLocationAction.java,v 1.10 2009/05/05 16:36:59 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.selection.ResourceSelectionWizard;
import org.eclipse.hyades.test.ui.wizard.LocationNewWizard;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * This class handles the action when the Add button on the Deployment editor 
 * is selected to add a new location association.
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Bianca Xue Jiang
 * @author  Marcelo Paternostro
 * @version May 5, 2009
 * @since   February 1, 2005
 */
public class AddLocationAction 
extends AddDeploymentChildAction
{
	/**
	 * Constructor for AddLocationAction
	 */
	public AddLocationAction()
	{
		super(UiPluginResourceBundle.BTN_ADD); 
		
		setToolTipText(UiPluginResourceBundle.ACT_LOC_ADD_TIP); 
		setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_LOCATION));
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (getDeployment(structuredSelection) != null);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		LocationNewWizard locationNewWizard = new LocationNewWizard(){
			
			protected void openEditor(IFile file) throws PartInitException{
				//No operation since we do not want to open the Location Editor. 
			}
		};
		
		WizardElement newFileWizardElement = new WizardElement(locationNewWizard);
		ResourceSelectionWizard fileSelectionWizard = new ResourceSelectionWizard(newFileWizardElement, locationNewWizard.getFileExtension());
		fileSelectionWizard.setWindowTitle(UiPluginResourceBundle.DLG_ASS_LOC);					 
		fileSelectionWizard.init(PlatformUI.getWorkbench(), new StructuredSelection());

		Shell parent = Display.getCurrent().getActiveShell();
		WizardDialog dialog = new WizardDialog(parent, fileSelectionWizard);
		dialog.create();
		int ret = dialog.open();
		if(ret == Window.OK)
		{
			EObject[] eObjects = fileSelectionWizard.getSelectedEObjects();
			if(eObjects != null && eObjects.length > 0)
			{
				TPFDeployment deployment = getDeployment(getStructuredSelection());
				for(int i = 0; i < eObjects.length; i++)
				{
					if(eObjects[i] instanceof CFGLocation)			
					{
						if(!ConfigurationUtil.containsById(deployment.getRefLocations(), (CFGLocation)eObjects[i]))
							deployment.getRefLocations().add(((CFGLocation)(eObjects[i])));		
					}						
				}
			}
		}
	}	
}
