/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddSUTAction.java,v 1.6 2008/01/21 17:19:27 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.internal.wizard.SUTNewWizard;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class AddSUTAction 
extends AddTestSuiteChildAction
{
	/**
	 * Constructor for AddTestComponentAction
	 */
	public AddSUTAction()
	{
		super(UiPluginResourceBundle.BTN_ADD); 
		
		setToolTipText(UiPluginResourceBundle.ACT_SUT_ADD_TIP); 
		setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_SUT));
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this, UiPlugin.getID() + ContextIds.ADD_SUT_ACT);						
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (getTestSuite(structuredSelection) != null);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		TPFTestSuite testSuite = getTestSuite(getStructuredSelection());
		SUTNewWizard sutNewWizard = new SUTNewWizard();
		sutNewWizard.setWindowTitle(UiPluginResourceBundle.WIZ_SUT_TTL); 

		openWizard(testSuite, sutNewWizard, "SUTWizard"); //$NON-NLS-1$
	}	
}
