/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddTestAssetAction.java,v 1.8 2008/11/04 14:20:24 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.core.util.ArtifactUtil;
import org.eclipse.hyades.test.ui.internal.component.ProxyNodeSelectionDialog;
import org.eclipse.hyades.test.ui.internal.model.ui.AddChildAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/**
 * This class handles the action when the Add button on the Artifact editor 
 * is selected to add a new test asset association.
 *
 * 
 * @author     Paul E. Slauenwhite
 * @author     Bianca Xue Jiang
 * @version    October 31, 2008
 * @since      February 1, 2005
 */
public class AddTestAssetAction extends AddChildAction
{

    /**
     * Sole Contructor.
     * @param text
     */
    public AddTestAssetAction()
    {
        super(Common_ConfigurationPackage.eINSTANCE.getCFGArtifact(), UiPluginResourceBundle.BTN_ADD); 
        setToolTipText(UiPluginResourceBundle.ACT_TAST_ADD_TIP); 
		//setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_TEST_ASSET));        
    }
    
    /**
	 * Sets the default artifact that is returned by 
	 * {@link #getArtifact(IStructuredSelection)}.  If <code>null</code> then the
	 * selection is analysed in order to identify the artifact.
	 * @param artifact
	 */
	public void setArtifact(CFGArtifact artifact)
	{
		setParent(artifact);
	}

	/**
	 * Returns the artifact associated with the first element of the structured 
	 * selection or <code>null</code>.
	 * @param structuredSelection
	 * @return CFGArtifact
	 */
	protected CFGArtifact getArtifact(IStructuredSelection structuredSelection)
	{
		return (CFGArtifact)getParent(structuredSelection);
	}	
	
	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (getArtifact(structuredSelection) != null);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run(){
		
		Shell activeShell = Display.getCurrent().getActiveShell();
				
		ProxyNodeSelectionDialog proxyNodeSelectionDialog = new ProxyNodeSelectionDialog(activeShell, 
				UiPluginResourceBundle.DLG_RESOURCE_SEL, 
				new String[]{ICommonConstants.TEST_SUITE_FILE_EXTENSION, 
					ICommonConstants.TEST_COMPONENT_EXTENSION,
					ICommonConstants.SUT_EXTENSION,
					ICommonConstants.DATAPOOL_FILE_EXTENSION}, 
				SWT.RESIZE); 

		if(proxyNodeSelectionDialog.open() == Window.OK){
		
			IProxyNode[] selectedProxyNodes = proxyNodeSelectionDialog.getSelectedProxyNodes();
			
			if(selectedProxyNodes.length > 0){

				//Set the wait cursor:
				activeShell.setCursor(new Cursor(activeShell.getDisplay(), SWT.CURSOR_WAIT));

				CFGArtifact artifact = getArtifact(getStructuredSelection());
				
				for (int counter = 0; counter < selectedProxyNodes.length; counter++) {
					
					if(selectedProxyNodes[counter] instanceof EObjectProxyNode){

						EObject eObject = ((EObjectProxyNode)(selectedProxyNodes[counter])).getEObject();
						
						if(eObject instanceof CFGClass){
							ArtifactUtil.associateTestAsset(((CFGClass)(eObject)), artifact);
						}
					}
				}
				
				//Set the default cursor:
				activeShell.setCursor(null);
			}
		}
	}
}
