/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddVariableAction.java,v 1.4 2010/03/31 19:18:11 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolConstants;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

/**
 * <p>Add variable action for adding a new variable or column to the 
 * datapool.</p>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul Slauenwhite
 * @version March 31, 2010
 * @since   March 2, 2005
 */
public class AddVariableAction extends DatapoolVariableSelectionAction {

    /**
     * @param editor
     * @param text
     */
    public AddVariableAction(DatapoolEditorExtension editor, String text)
    {
        super(editor, text);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run(){
    	
    	IDatapool datapool = getParent();
    	
    	if(datapool.getVariableCount() >= DatapoolConstants.MAXIMUM_VARIABLE_LIMIT){
			MessageDialog.openWarning(Display.getCurrent().getActiveShell(), UiPluginResourceBundle.DatapoolEditor_Variables, NLS.bind(UiPluginResourceBundle.DATA_COL_DLG_ERROR_VARIABLE_LIMIT_EXCEEDED, DatapoolConstants.MAXIMUM_VARIABLE_LIMIT));
    	}        
    	else{
    		
    		IDatapoolVariable variable = datapool.constructVariable();

    		int selectionIndex = getSelectionIndex();
    		
    		if((selectionIndex > -1) && (selectionIndex < (datapool.getVariableCount() - 1))){
    		    getParent().insertVariable(variable, (selectionIndex + 1));
    		}
    		else{
    			datapool.appendVariable(variable);
    		}
    	}
	}
}
