/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolChildrenSelectionAction.java,v 1.3 2005/07/26 21:27:10 mddunn Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import java.util.List;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionListenerAction;

/**
 * This class provides common functions used by datapool actions to manipulate
 * <i>Equivalence Classes</i> and <i>Variables</i>.
 * 
 * @author bjiang
 * @since  3.3
 */
public abstract class DatapoolChildrenSelectionAction extends SelectionListenerAction {

	private DatapoolEditorExtension editor;
	
	/**
	 * Creates an instance of this class that refreshes with the editor object.
	 * 
	 * @param editorExtension
	 * @param text
	 */
	public DatapoolChildrenSelectionAction(DatapoolEditorExtension editorExtension, String text)
	{
		super(text);
		this.editor = editorExtension;
	}
	
	public DatapoolEditorExtension getEditor()
	{
		return editor;
	}
	
	public IDatapool getParent()
	{
		return editor.getDatapool();
	}
	
	protected abstract List getChildren();
	
	protected abstract int getSelectionIndex();
	
	/* (non-Javadoc)
     * @see org.eclipse.ui.actions.BaseSelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection)
    {        
        if(selection.isEmpty())
            return false;
        
        return true;
    }
}
