/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FailAction.java,v 1.2 2005/07/26 21:27:10 mddunn Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.test.ui.internal.editor.form.util.EventSection;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;

public class FailAction extends ChildrenSelectionAction {

    private EventSection.EventContentProvider ecp;
    private boolean actionPerformed = false;
    
    public FailAction(String text) {
        super(text);
    }
    
    public void dispose()
    {
        ecp = null;
    }

    public EventSection.EventContentProvider getEcp() {
        return ecp;
    }
    

    public void setEcp(EventSection.EventContentProvider ecp) {
        this.ecp = ecp;
    }

    public boolean isActionPerformed() {
        return actionPerformed;
    }
    

    public void setActionPerformed(boolean actionPerformed) {
        this.actionPerformed = actionPerformed;
    }
    
    protected int getChildIndex(Object parent, Object child) {
        Object[] children = getEcp().getChildren(parent);
        for (int i = 0; i < children.length; i++) {
            if (children[i].equals(child)) {
                return i;
            }
        }
        return -1;
    }

}
