/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GetNextFailAction.java,v 1.6 2007/03/22 14:42:05 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.StructuredSelection;

public class GetNextFailAction extends FailAction {
    
    public GetNextFailAction() {
        super(UiPluginResourceBundle.LBL_NEXT_ERROR); 

        setToolTipText(UiPluginResourceBundle.TOOLTIP_NEXT_ERROR); 
    }
    
    /**
     * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
     */
    public void dispose()
    {
        super.dispose();
    }
    
    /**
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run()
    {
        setActionPerformed(false);
        EObject objectSelection = (EObject)getStructuredSelection().getFirstElement();
        EObject parent = (EObject)getEcp().getParent(objectSelection);
        int childIndex =  -1;
        if (parent instanceof TPFExecutionHistory) {
            parent=(EObject)((TPFExecutionHistory)parent).getExecutionResult();
        }
        childIndex = getChildIndex(parent,objectSelection);
        Object nextFail = checkAllChildren(objectSelection);
        if (nextFail!=null) {
            StructuredSelection newSelection = new StructuredSelection(nextFail);
            getStructuredViewer().setSelection(newSelection, true);
        } else {
            nextFail = getVerdictEvent(parent,childIndex);
            if (nextFail!=null) {
                StructuredSelection newSelection = new StructuredSelection(nextFail);
                getStructuredViewer().setSelection(newSelection, true);
            }
        }
        if (nextFail==null) {
            while (!(parent instanceof TPFExecutionResult)) {
                parent = (EObject)getEcp().getParent(parent);
                if (parent == null) {
                    return;
                }
            }
            TPFExecutionResult er = (TPFExecutionResult)parent;
            if (!hasFail(er)) {
                return;
            }
            nextFail = getVerdictEvent(er.getExecutionHistory().getExecutionEvents().get(0),-1);
            StructuredSelection newSelection = new StructuredSelection(nextFail);
            getStructuredViewer().setSelection(newSelection, true);            
        }

        setActionPerformed(true);
    }
    
    protected Object getVerdictEvent(Object parent, int childIndex) {
        Object[] children = getEcp().getChildren(parent);
        for (int i = childIndex+1; i < children.length; i++) {
            Object child = children[i];
            if (child instanceof TPFVerdictEvent 
                    && ( ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.FAIL
                    || ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.ERROR) ) {
                return child;
            } else {
                Object returnObject = checkAllChildren(child);
                if (returnObject!=null) {
                    return returnObject;
                }
            }
        }
        EObject currentParent = (EObject)getEcp().getParent(parent);
        if (currentParent==null) {
            return null;
        } else {
            if (currentParent instanceof TPFExecutionHistory) {
                currentParent=(EObject)((TPFExecutionHistory)currentParent).getExecutionResult();
            }
            childIndex = getChildIndex(currentParent,parent);
            Object fail = getVerdictEvent(currentParent,childIndex);
            if (fail!=null) {
                return fail;
            }
        }
        return null;
    }
    
    public Object checkAllChildren(Object parent){
        Object[] children = getEcp().getChildren(parent);
        for (int i = 0; i < children.length; i++) {
            Object child = children[i];
            if (child instanceof TPFVerdictEvent 
            && ( ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.FAIL
            || ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.ERROR) ) {
                return child;
            } else {
                Object returnObject = checkAllChildren(child);
                if (returnObject!=null) {
                    return returnObject;
                }
            }
        }
        return null;
    }
    
    public boolean hasFail(TPFExecutionResult er) {
        if (getVerdictEvent(er.getExecutionHistory().getExecutionEvents().get(0),-1)!=null) {
            return true;
        }
        return false;
    }

}
