/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GetPrevFailAction.java,v 1.7 2007/03/22 14:42:06 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.StructuredSelection;

public class GetPrevFailAction extends FailAction {
        
    public GetPrevFailAction() {
        super(UiPluginResourceBundle.LBL_PREV_ERROR); 

        setToolTipText(UiPluginResourceBundle.TOOLTIP_PREV_ERROR); 
    }
    
    /**
     * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
     */
    public void dispose()
    {
        super.dispose();
    }
    

    /**
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run()
    {
        setActionPerformed(false);
        EObject objectSelection = (EObject)getStructuredSelection().getFirstElement();
        EObject parent = (EObject)getEcp().getParent(objectSelection);
        int childIndex =  -1;
        if (parent instanceof TPFExecutionHistory) {
            parent=(EObject)((TPFExecutionHistory)parent).getExecutionResult();
        }
        childIndex = getChildIndex(parent,objectSelection);
        Object prevFail = getVerdictEvent(parent,childIndex);
        if (prevFail!=null) {
            StructuredSelection newSelection = new StructuredSelection(prevFail);
            getStructuredViewer().setSelection(newSelection, true);
        }
        if (prevFail==null) {
            while (!(parent instanceof TPFExecutionHistory)) {
                parent = (EObject)getEcp().getParent(parent);
                if (parent == null) {
                    return;
                }
            }
            TPFExecutionHistory eh = (TPFExecutionHistory)parent;
            parent = (EObject)eh.getExecutionResult();
            Object lastElement = getLastElement(parent);
            if (lastElement==null) {
                return;
            }
            StructuredSelection newSelection = new StructuredSelection(lastElement);
            getStructuredViewer().setSelection(newSelection, true);
            run();
        }
        setActionPerformed(true);
    }
    
    protected Object getVerdictEvent(Object parent, int childIndex) {
        Object[] children = getEcp().getChildren(parent);
        for (int i = childIndex-1; i >= 0; i--) {
            Object child = children[i];
            if (child instanceof TPFVerdictEvent 
                    && ( ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.FAIL
                    || ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.ERROR) )
            {
                return child;
            } else {
                Object returnObject = checkAllChildren(child);
                if (returnObject!=null) {
                    return returnObject;
                }
            }
        }
        EObject currentParent = (EObject)getEcp().getParent(parent);
        if (currentParent==null) {
            return null;
        } else {
            if (currentParent instanceof TPFExecutionHistory) {
                currentParent=(EObject)((TPFExecutionHistory)currentParent).getExecutionResult();
            }
            childIndex = getChildIndex(currentParent,parent);
            Object fail = getVerdictEvent(currentParent,childIndex);
            if (fail!=null) {
                return fail;
            }
        }
        return null;
    }
    
    public Object checkAllChildren(Object parent){
        Object[] children = getEcp().getChildren(parent);
        for (int i = children.length-1; i >= 0; i--) {
            Object child = children[i];
            if (child instanceof TPFVerdictEvent 
            && ( ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.FAIL
            || ((TPFVerdictEvent)child).getVerdict().getValue()==TPFVerdict.ERROR) ) {
                return child;
            } else {
                Object returnObject = checkAllChildren(child);
                if (returnObject!=null) {
                    return returnObject;
                }
            }
        }
        return null;
    }
    
    public Object getLastElement(Object parent) {
        Object[] children = getEcp().getChildren(parent);
        if (children.length>0) {
            Object lastChild = children[children.length-1];
            Object returnedObject = getLastElement(lastChild);
            if (returnedObject!=null) {
                return returnedObject;
            }
        } else {
            return parent;
        }
        return null;
    }
}
