/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MoveEquivalenceClassDown.java,v 1.3 2005/07/26 21:27:10 mddunn Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class handles <i>Down</i> action in datapool editor to move the position of a
 * <i>equivalence class</i>.
 * 
 * @author bjiang
 * @since  3.3
 */
public class MoveEquivalenceClassDown extends DatapoolEquivalenceClassSelectionAction
{
    /**
     * @param editorExtension
     * @param text
     */
    public MoveEquivalenceClassDown(DatapoolEditorExtension editorExtension, String text)
    {
        super(editorExtension, text);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.action.DatapoolChildrenSelectionAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection)
    {
        if(!super.updateSelection(selection))
            return false;
        
        int index = getSelectionIndex();
        return ((index > -1 && index <= (getParent().getEquivalenceClassCount() - 2)) ? true : false);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run()
    {
        int index = getSelectionIndex();
        if(index <= (getParent().getEquivalenceClassCount() - 2))
            getParent().moveEquivalenceClass(index, (index + 1));
    }
}
