/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenArtifactAction.java,v 1.9 2009/05/04 14:37:21 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.SelectionListenerAction;

/**
 * <p>Open action of a {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}
 * resource editor.</p>
 *
 *
 * @author  Paul Slauenwhite
 * @author  Bianca Xue Jiang
 * @version May 4, 2009
 * @since	February 1, 2005
 */
public class OpenArtifactAction extends SelectionListenerAction
{
	private StructuredViewer structuredViewer;
	private boolean actionPerformed;
	
	/**
	 * Constructor for OpenArtifactAction
	 */
	public OpenArtifactAction()
	{
		super(UiPluginResourceBundle.ACT_OPEN); 
	
		setToolTipText(UiPluginResourceBundle.ACT_ART_OPN_TIP); 
		setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_ARTIFACT));
	}
	
	/**
	 * Sets the action performed flag.
	 * @param actionPerformed
	 */
	protected void setActionPerformed(boolean actionPerformed)
	{
		this.actionPerformed = actionPerformed;
	}

	/**
	 * Returns whether the most run has being completed.  This information is reset 
	 * at the selection changes. 
	 * @return boolean.
	 */
	public boolean actionPerformed()
	{
		return actionPerformed;
	}

	/**
	 * Sets the structuredViewer that should be updated after running this action.
	 * @param structuredViewer
	 */
	public void setStructuredViewer(StructuredViewer structuredViewer)
	{
		this.structuredViewer = structuredViewer;
	}

	/**
	 * Returns the structuredViewer to be updated after running this action.
	 * @return structuredViewer
	 */
	public StructuredViewer getStructuredViewer()
	{
		return structuredViewer;
	}	
	
	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof CFGArtifact);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		IStructuredSelection selection = (IStructuredSelection)getStructuredViewer().getSelection();
		if( selection.size() == 1 && selection.getFirstElement() instanceof CFGArtifact)
		{
			Resource resource = ((EObject)selection.getFirstElement()).eResource();
			TestUIUtil.openEditor(resource, TestUIExtension.ARTIFACT_EDITOR_PART_ID, false);
		}		
	}
}
