/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenEquivalenceClassAction.java,v 1.3 2005/07/26 21:27:10 mddunn Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;

/**
 * This class handles <i>Open</i> action in datapool editor to open up
 * <i>equivalence class</i> tab.
 * 
 * @author bjiang
 * @since  3.3
 */
public class OpenEquivalenceClassAction extends
        DatapoolEquivalenceClassSelectionAction
{

    /**
     * @param datapool
     * @param text
     */
    public OpenEquivalenceClassAction(DatapoolEditorExtension editorExtension, IDatapool datapool, String text)
    {
        super(editorExtension, text);
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run()
    {
        int pageIndex = getEditor().getEquivalenceClassPageIndex(getSelectionIndex());
        getEditor().getHyadesEditorPart().setActivePage(pageIndex);
    }
}
