/********************************************************************** 
 * Copyright (c) 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 *  
 * 
 * Contributors: 
 *      pnedelec (IBM) - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.test.ui.action.model.RemoveFeatureChildrenAction;

/** 
 * For a given deployment, this action removes an artifact/location and purge the existing pair that referenced it.
 * See Bugzilla #126222.
 * 
 * @author pnedelec
 * @since 4.2
 */
public class RemoveDeploymentPairElementAction extends RemoveFeatureChildrenAction {
    private EStructuralFeature pairFeature;

    public RemoveDeploymentPairElementAction(EObject parent, EStructuralFeature feature, EStructuralFeature pairFeature, boolean saveChanges) {
        super(parent, feature, saveChanges);
        this.pairFeature = pairFeature;
    }

    /** 
     * @see org.eclipse.hyades.test.ui.action.model.RemoveFeatureChildrenAction#run()
     */
    public void run() {
        setActionPerformed(false);
        //- Remove the pairs that reference the selection
        Object allPairs = getParent().eGet(pairFeature);
        Object[] selections = getChildren().toArray();//- The selection is an Artifact or Location
        for (int i = 0; i < selections.length; i++) {
            if (allPairs instanceof List) {
                List thePairs = findPairsContaining(selections[i], (List) allPairs);
                Iterator it = thePairs.iterator();
                while (it.hasNext()) {
                    EcoreUtil.remove(getParent(), pairFeature, it.next());
                }
            }
        }
        //- Now remove the seleted elements
        super.run();
        setActionPerformed(true);
    }

    private List findPairsContaining(Object element, List pairList) {
        List ret = new LinkedList();
        Iterator it = pairList.iterator();
        while (it.hasNext()) {
            CFGArtifactLocationPair pair = (CFGArtifactLocationPair) it.next();
            if (element.equals(pair.getArtifact()) || element.equals(pair.getLocation())) {
                ret.add(pair);
            }
        }
        return ret;
    }

}
