/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RemoveEquivalenceClassAction.java,v 1.2 2005/06/08 22:24:16 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class handles <i>Remove</i> action in datapool editor to remove a
 * <i>Equivalence Class</i>.
 * 
 * @author bjiang
 * @since  3.3
 */
public class RemoveEquivalenceClassAction extends DatapoolEquivalenceClassSelectionAction {

	/**
	 * 
	 * @param editor
	 * @param text
	 */
	public RemoveEquivalenceClassAction(DatapoolEditorExtension editor, String text) {
		super(editor, text);
	}
	
	/* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.action.DatapoolChildrenSelectionAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection)
    {
        if(!super.updateSelection(selection))
            return false;
        
        return (getParent().getEquivalenceClassCount() < 2) ? false : true;
    }
	
	public void run() {
	    if(getParent().getEquivalenceClassCount() < 2)
	        return;
		int index = getSelectionIndex();
		if(index > -1)
		{
		    // default equivalence class is not in data model thus does not get persisted. 
			// Add this functionality back when this is resolved.
		    /*if(getParent().getDefaultEquivalenceClassIndex() == index)
		    {
		        MessageDialog changeDefaultEC = new MessageDialog(Display.getCurrent().getActiveShell(),
		                									TestUIPlugin.getString("DatapoolEditor.RemoveEquivalenceClass"), //$NON-NLS-1$
		                									null,
		                									TestUIPlugin.getString("DatapoolEditor.RemoveDefaultEquivalenceClassQuestion"), //$NON-NLS-1$
		                									MessageDialog.QUESTION,
		                									new String[]{TestUIPlugin.getString("Word.Yes"), TestUIPlugin.getString("Word.No")}, //$NON-NLS-1$ //$NON-NLS-2$
		                									0);
		        if(changeDefaultEC.open() == MessageDialog.OK)
		            getParent().setDefaultEquivalenceClassIndex(0);
		        else
		            return;
		    }*/
			getParent().removeEquivalenceClass(index);
		}
	}
}
