/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RemoveVariableAction.java,v 1.3 2008/05/09 16:45:16 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class handles <i>Remove</i> action in datapool editor to remove a
 * <i>Variable</i> (column).
 * <p/>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul E. Slauenwhite
 * @version April 29, 2008
 * @since   March 2, 2005
 */
public class RemoveVariableAction extends DatapoolVariableSelectionAction
{
	/**
	 * 
	 * @param editor
	 * @param text
	 */
	public RemoveVariableAction(DatapoolEditorExtension editor, String text) {
		super(editor, text);
	}
	
	/* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.action.DatapoolChildrenSelectionAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection)
    {
        if(!super.updateSelection(selection))
            return false;
        
        return (getParent().getVariableCount() < 2) ? false : true;
    }
	
	public void run() {
		
		IDatapool datapool = getParent();
		
	    if(datapool.getVariableCount() > 1){
	    
			int index = getSelectionIndex();
			
			if(index > -1){
				
				datapool.removeVariable(index);
				
				//Remove the datapool's challenge if there are no encrypted variables:
				if(!DatapoolEncryptManager.containsEncryptedVariable(datapool)){
					DatapoolEncryptManager.removeKey(datapool);
				}
			}
		}
	}
}
