/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SelectDatapoolInNavigatorAction.java,v 1.14 2007/04/26 20:23:28 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolAction;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.ITestNavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class SelectDatapoolInNavigatorAction extends Action implements IDatapoolAction {

	Object[] selectedElements = null;
	DatapoolTable table = null;
	
	public SelectDatapoolInNavigatorAction()
	{
		super(UiPluginResourceBundle.SEL_DP_TEST_NAV_TEXT); 
		setDescription(UiPluginResourceBundle.SEL_DP_TEST_NAV_LDESC); 
	}

	public void run()
	{
		if(table == null)
			return;
		IDatapool datapool = table.getDatapool();
		if(datapool == null)
			return;
		TestNavigator testNavigator = openView();
		if(testNavigator != null)
		{
			EObject eDatapool = (EObject)datapool;
			IFile file = EMFUtil.getWorkspaceFile(eDatapool.eResource());
			if (file != null)
			{
				testNavigator.selectReveal(new StructuredSelection(file));
			}
		}
	}

	public void aboutToShow(boolean bShow)
	{
		setEnabled(bShow);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolAction#setDatapoolTable(org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable)
	 */
	public void setDatapoolTable(DatapoolTable table) 
	{
		this.table = table;
	}	
	
	private TestNavigator openView() 
	{
		try
		{
			IWorkbenchPage page = UiPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
			if (page != null)
				return (TestNavigator)page.showView(ITestNavigator.ID);
		}
		catch (Exception e)
		{
			UiPlugin.logError(e);
		}
		return null;
	}
}
