/*******************************************************************************
 * Copyright (c) 2008, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProxyNodeContentProvider.java,v 1.4 2010/05/06 12:28:32 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.component;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * <p>Proxy node resource content provider.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Jerome Bozier
 * @version May 6, 2010
 * @since   October 31, 2008
 */
public class ProxyNodeContentProvider implements ITreeContentProvider{
	
	private int filter = SHOW_ALL;
    private String[] fileExtensions = null;
    
    public static final int FILTER_FOLDERS = 2;
    public static final int SHOW_ALL = 4;
	
	public ProxyNodeContentProvider(String[] fileExtensions){
		
	    if((fileExtensions == null) || (fileExtensions.length == 0)){
	        throw new IllegalArgumentException();
	    }
	    
        this.fileExtensions = fileExtensions;
	}

	public void setFilter(int filter){
		this.filter = filter;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(final Object inputElement){
		
		if(inputElement instanceof IWorkspaceRoot){
			
			if(filter == FILTER_FOLDERS){			
			
				List elements = new ArrayList();		
				IProject[] projects = ((IWorkspaceRoot)(inputElement)).getProjects();					
				
				for(int counter = 0; counter < projects.length; counter++){
                    
					if(projects[counter].isAccessible()) {
                      
						Object[] children = getChildren(projects[counter]);
                        
						for (int index = 0; index < children.length; index++)
                            elements.add(children[index]);
                    }											
				}
				
				return (elements.toArray());
			}
			else{

				List<Object> elements = new ArrayList<Object>();		
				IProject[] projects = ((IWorkspaceRoot)(inputElement)).getProjects();					

				for(int counter = 0; counter < projects.length; counter++){

					if((projects[counter].isAccessible()) && (!TestNavigator.getFiltersManager().filter(projects[counter]))) {
						elements.add(projects[counter]);
					}											
				}
				
				return (elements.toArray());
			}	
		}
		
		return (getChildren(inputElement));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element){
		
		if(element instanceof IResource){
			return (((IResource)(element)).getParent());
		}
		
		if((element instanceof IProxyNode) && (filter == SHOW_ALL)){
			
			IResource resource = ((IProxyNode)(element)).getUnderlyingResource();

			if(resource != null){
				return (resource.getParent());
			}
		}

		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element){
		return (getChildren(element).length > 0);
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement){
		
		if(parentElement instanceof IContainer){
			
			//Check for closed projects:
			if ((parentElement instanceof IProject) && (!((IProject)(parentElement)).isOpen())) {
				return (new Object[0]);
			}
			
			try{
				
				List children = new ArrayList(); 

				IResource[] resources = ((IContainer)(parentElement)).members();

				for(int counter = 0; counter < resources.length; counter++){
					
					//Folders:
					if(resources[counter].getType() != IResource.FILE){
						
						if(filter == FILTER_FOLDERS){
							
							Object[] childResources = getChildren(resources[counter]);
							
							for(int index = 0; index < childResources.length; index++){
							
								if(!children.contains(childResources[index])){
									children.add(childResources[index]);
								}
							}
						}
						else if((!children.contains(resources[counter])) && (!TestNavigator.getFiltersManager().filter(resources[counter]))){
							children.add(resources[counter]);
						}
					}
					
					//Files:
					else{
						
						IFile file = ((IFile)(resources[counter]));
						
						for(int index = 0; index < fileExtensions.length; index++){
							
							String extension = file.getFileExtension();
							
							if((extension != null) && (extension.trim().equals(fileExtensions[index].trim()))){

								IProxyNode proxyNode = FileProxyNodeCache.getInstance().getProxy(file);

								if((proxyNode != null) && (!children.contains(proxyNode)) && (!TestNavigator.getFiltersManager().filter(proxyNode))) { // adding null element break jface checking
									children.add(proxyNode);
								}

								break;
							}
						}
					}
				}

				return (children.toArray());
			}
			catch (CoreException c){	
				UiPlugin.logError(c);
			}
		}		
		else if(parentElement instanceof IProxyNode){
			return (((IProxyNode)(parentElement)).getChildren());
		}
		
		return (new Object[0]);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput){
		//No-operation.
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		//No-operation.
	}		
}
