/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProxyNodeLabelProvider.java,v 1.1 2008/11/04 14:20:23 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * ProxyNodeLabelProvider.java
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version October 31, 2008
 * @since   October 31, 2008
 */
public class ProxyNodeLabelProvider extends LabelProvider{
	
    private Map imageMap = null;

	/**
	 * No-argument constructor.
	 */
	public ProxyNodeLabelProvider(){
		
		super();

        imageMap = new HashMap();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.LabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element){

		if(element != null){
			
			if(element instanceof IProxyNode){				
				return (((IProxyNode)(element)).getImage());
			}
			else if(element instanceof IAdaptable){

				IWorkbenchAdapter adapter = ((IWorkbenchAdapter)(((IAdaptable)(element))).getAdapter(IWorkbenchAdapter.class));

				if(adapter != null) {
					
					ImageDescriptor imageDescriptor = adapter.getImageDescriptor(element);
					Image image = ((Image)(imageMap.get(imageDescriptor)));
					
					if (image == null) {
					
						image = imageDescriptor.createImage();
						
						imageMap.put(imageDescriptor,image);
					}
					
					return image;
				}
			}
		}

        return null;            
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.LabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element)
	{
		if(element != null){

			if(element instanceof IProxyNode){
				
				if(element instanceof CMNNamedElementProxyNode){
					return (((CMNNamedElementProxyNode)(element)).getName());
				}
				else{
					return (((IProxyNode)(element)).getUnderlyingResource().getName());
				}
			}			
			else if(element instanceof IAdaptable){
				
				IWorkbenchAdapter adapter = ((IWorkbenchAdapter)(((IAdaptable)(element))).getAdapter(IWorkbenchAdapter.class));
	
				if(adapter != null)
					return (adapter.getLabel(element));
			}
	
			return (element.toString());
		}
		
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.BaseLabelProvider#dispose()
	 */
	public void dispose(){

		if (imageMap != null) {
            
			Iterator imageMapIterator = imageMap.values().iterator();
			
			while(imageMapIterator.hasNext()){
				((Image)(imageMapIterator.next())).dispose();
            }
            
			imageMap.clear();
        }
	
		super.dispose();
	}
}
