/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProxyNodeSelectionDialog.java,v 1.1 2008/11/04 14:20:23 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.component;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/**
 * <p>Dialog for displaying and selecting proxy nodes based 
 * on the extension of the associated file resource.</p>
 * 
 * <p><b>Note:</b> Only file resources with a registered 
 * proxy factory are displayed in this dialog.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version October 31, 2008
 * @since   October 31, 2008
 */
public class ProxyNodeSelectionDialog extends Dialog {
	
	private String title = null;
	private String[] fileExtensions = null;
	private ProxyNodeSelectionViewer viewer = null;
		
    public ProxyNodeSelectionDialog(Shell parentShell, String title, String[] fileExtensions) {
        this(parentShell, title, fileExtensions, SWT.NONE);
    }

    public ProxyNodeSelectionDialog(Shell parentShell, String title, String[] fileExtensions, int style) {

    	super(parentShell);
        
    	this.title = title;
        this.fileExtensions = fileExtensions;
        
        setShellStyle(parentShell.getStyle() | style);
    }
		
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent){
		
		Composite composite = ((Composite)(super.createDialogArea(parent)));
		
		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 300;
		gridData.widthHint = 250;
		
		composite.setLayoutData(gridData);

		viewer = new ProxyNodeSelectionViewer(composite, ResourcesPlugin.getWorkspace().getRoot(), fileExtensions, (SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER));
		viewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

			public void doubleClick(DoubleClickEvent event) {
				
				viewer.setSelection();
				
				buttonPressed(IDialogConstants.OK_ID);
			}
		});
		
		return composite;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	protected void configureShell(Shell shell) {
		
		super.configureShell(shell);
		
		if(title != null){
			shell.setText(title);
		}
	}
	
	public IProxyNode[] getSelectedProxyNodes(){
		return (viewer.getSelectedProxyNodes());
	}
}
