/*******************************************************************************
 * Copyright (c) 2008, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProxyNodeSelectionViewer.java,v 1.4 2009/04/17 00:47:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

/**
 * <p>This class implements a component with a button to filter folder and 
 * a tree viewer to show resources with a certain file extension in the 
 * workspace.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version April 16, 2009
 * @since   October 31, 2008
 */
public class ProxyNodeSelectionViewer {
	
	private TreeViewer assetViewer = null;
	private Button filterButton = null;
	private ProxyNodeContentProvider contentProvider = null;
	private List selectedProxyNodes = null;
	
	public ProxyNodeSelectionViewer(Composite parent, Object rootObject, String[] fileExtensions, int style) {
		createContents(parent, rootObject, fileExtensions, style);
	}

	public void setSelection() {
		
		ISelection selection = assetViewer.getSelection();
		
		if((selection != null) && (!selection.isEmpty())){
			
			selectedProxyNodes = new ArrayList();

			Iterator selectionIterator = ((IStructuredSelection)(selection)).iterator();
			
			while (selectionIterator.hasNext()) {
			
				Object selectedElement = selectionIterator.next();
				
				if (selectedElement instanceof IProxyNode){
					selectedProxyNodes.add(((IProxyNode)(selectedElement)));
				}
			}
		}
	}

	public Button getFilterButton() {
		return filterButton;
	}

	public TreeViewer getViewer(){
		return assetViewer;
	}
	
	public IProxyNode[] getSelectedProxyNodes() {
		
		if (selectedProxyNodes == null){
			return (new IProxyNode[0]);
		}

		return ((IProxyNode[])(selectedProxyNodes.toArray(new IProxyNode[selectedProxyNodes.size()])));
	}

	private void createContents(Composite parent, Object rootObject, String[] fileExtensions, int style) {
		
		GridLayout gridLayout = new GridLayout();
		gridLayout.marginWidth = 0;
		gridLayout.marginHeight = 0;
		
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(gridLayout);
		composite.setLayoutData(GridDataUtil.createFill());

		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 150;

		Tree tree = new Tree(composite, style);
		tree.setLayoutData(gridData);

		contentProvider = new ProxyNodeContentProvider(fileExtensions);
		contentProvider.setFilter(ProxyNodeContentProvider.FILTER_FOLDERS);

		assetViewer = new TreeViewer(tree);
		assetViewer.setContentProvider(contentProvider);
		assetViewer.setLabelProvider(new ProxyNodeLabelProvider());
		assetViewer.setSorter(new ViewerSorter() {
			
			public void sort(Viewer viewer, Object[] elements) {
			
				if (elements.length > 0){
					super.sort(viewer, elements);
				}
			}

			public int category(Object element) {
				
				if (element instanceof IResource){
					return 0;
				}

				return 10;
			}
		});
		assetViewer.setInput(rootObject);
		assetViewer.expandToLevel(2);
		
		((Tree)(assetViewer.getControl())).addSelectionListener(new SelectionAdapter(){
			
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e){
				setSelection();
			}
		});
		
		filterButton = new Button(composite, SWT.CHECK);
		filterButton.setText(UiPluginResourceBundle.SHOW_FOLDERS); 
		filterButton.addSelectionListener(new SelectionAdapter(){
			
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e){
				
				if(filterButton.getSelection()){
					contentProvider.setFilter(ProxyNodeContentProvider.SHOW_ALL);
				}
				else{
					contentProvider.setFilter(ProxyNodeContentProvider.FILTER_FOLDERS);	
				}

				ISelection selection = assetViewer.getSelection();				

				assetViewer.refresh();

				if(!selection.isEmpty()){
					assetViewer.setSelection(selection, true);
				}
			}	
		});
	}
}
