/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResourceSelectionDialog.java,v 1.6 2007/03/22 14:42:04 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * This class implements a dialog to select one or more resources with a certain file extension
 * in the workspace.
 * 
 * @author bjiang
 * @since	1.3
 * @deprecated use org.eclipse.hyades.test.ui.dialog.ResourceSelectionDialog instead.
 */
public class ResourceSelectionDialog extends Dialog implements SelectionListener
{
	private String fileExtension;
	
	private String title;
	private Button filterButton;
	private TreeViewer hostViewer;
	private HostsContentProvider contentProvider;
	private Image fileImage;
	
	private EObject[] selectedEObjects;
	
	
	/**
	 * @param parentShell
	 */
	public ResourceSelectionDialog(Shell parentShell, String title, String fileExtension, Image fileImage)
	{
		super(parentShell);
		this.title = title;
		this.fileExtension = fileExtension;
		this.fileImage = fileImage;
	}
	
	
	private class HostsContentProvider implements ITreeContentProvider
	{
		public static final int FILTER_FOLDERS = 2;
		public static final int SHOW_ALL = 4;
		
		private int filter;
		private ArrayList list = new ArrayList();
	
		public HostsContentProvider()
		{ 
		}

		public int getFilter()
		{
			return filter;
		}

		public void setFilter(int filter)
		{
			this.filter = filter;
		}
		
		public void dispose()
		{
			list.clear();
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput)
		{
		}

		public Object getParent(Object element)
		{
			if(element instanceof IResource)
				return ((IResource)element).getParent();
			
			if(element instanceof EObject)
			{
				EObject eObject = (EObject)element;			
				switch(filter)
				{
					case SHOW_ALL:
						IFile file = EMFUtil.getWorkspaceFile(eObject);
						if(file != null)
							return file.getParent();
						break;
				}
			}

			return null;
		}

		public boolean hasChildren(Object element)
		{
			return (getChildren(element).length > 0);
		}	

		public Object[] getElements(final Object inputElement)
		{
			if(inputElement instanceof IWorkspaceRoot)
			{			
				if(getFilter() == FILTER_FOLDERS)
				{			
					list.clear();		
					IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();					
					
					for(int idx=0; idx<projects.length; idx++)
					{
						Object[] children = getChildren(projects[idx]);
						for(int i=0; i<children.length; i++)
							list.add(children[i]);						
					}
					
					return list.toArray();
				}
				else
				{
					return ((IWorkspaceRoot)inputElement).getProjects();				
				}				
			}
			
			return getChildren(inputElement);
		}

		/**
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
		 */
		public Object[] getChildren(Object parentElement)
		{
			if(parentElement instanceof IContainer)
			{
				List children = new UniqueEList(); 
				IResource[] resources = null;
				try
				{
					resources = ((IContainer)parentElement).members();
				}
				catch (CoreException e)
				{
					UiPlugin.logError(e);
					return new Object[0];
				}
			 
				for(int i = 0, maxi = resources.length; i < maxi; i++)
				{
					if(resources[i].getType() != IResource.FILE)
					{
						if(filter == FILTER_FOLDERS)
						{
							Object[] tmpArray = getChildren(resources[i]);
							for(int k=0; k<tmpArray.length; k++)
							   children.add(tmpArray[k]);
						}
						else
							children.add(resources[i]);
					}
					else
					{
							IFile file = (IFile)resources[i];
							if(file.getFileExtension().equals(fileExtension))
							{
								EObject[] eObjects = EMFUtil.load(null, (IFile)resources[i]);
								for (int idx=0; idx<eObjects.length; idx++)
								{
									Object eObject = eObjects[idx];
									children.add(eObject);
								   
								}						    	
							}
					}
				}
			
				return children.toArray();
			}		
			else if(parentElement instanceof Resource)
				return ((Resource)parentElement).getContents().toArray();
		
			return new Object[0];
		}		
	}
	
	/**
	 * 
	 */
	private class HostsLabelProvider extends LabelProvider
	{
		private Hashtable ovelayCache;
		private boolean useImages;
		private Image image;
	
		/**
		 * Constructor for PerspectiveLabelProvider
		 */
		public HostsLabelProvider(boolean useImages, Image image)
		{
			super();
			this.useImages = useImages;
			this.image = image;
			ovelayCache = new Hashtable();
		}
	
		/**
		 * @see LabelProvider#getImage(Object)
		 */
		public Image getImage(Object element)
		{
			if((!useImages) || (element == null))
				return null;

			if(this.image != null)
				return image;

			if (element instanceof IAdaptable)
			{
				IWorkbenchAdapter adapter =
					(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

				if(adapter != null)
					return adapter.getImageDescriptor(element).createImage();
			}

			return null;			
		}

		/**
		 * @see LabelProvider#getText(Object)
		 */
		public String getText(Object element)
		{
			if(element == null)
				return ""; //$NON-NLS-1$

			String text = null;
		
			if(element instanceof EObject)
			{
				IFile file = EMFUtil.getWorkspaceFile((EObject)element);
				text = file.getName();
			}			
			else if(element instanceof IAdaptable)
			{
				IWorkbenchAdapter adapter =
					(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

				if(adapter != null)
					text = adapter.getLabel(element);
			}

			if(text == null)
				text = element.toString();
			
			return text;		
		}
		
	
		/**
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
		 */
		public void dispose()
		{
			if(ovelayCache != null)
			{
				for(Iterator i = ovelayCache.values().iterator(); i.hasNext();)
				{
					Image image = (Image)i.next();
					image.dispose();
				}
				ovelayCache.clear();
			}
		
			super.dispose();
		}
	}	
	
	
	protected Control createDialogArea(Composite parent)
	{
		Composite composite = (Composite)super.createDialogArea(parent);
		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 300;
		gridData.widthHint = 250;
		composite.setLayoutData(gridData);
	
		filterButton = new Button(composite, SWT.CHECK);
		filterButton.setText(UiPluginResourceBundle.SHOW_FOLDERS); 
		filterButton.addSelectionListener(this);
		createViewer(composite);
		hostViewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
		((Tree)hostViewer.getControl()).addSelectionListener(this);
		((TreeViewer)hostViewer).expandToLevel(2);
		
		return composite;
	}
	
	protected StructuredViewer createViewer(Composite parent)
	{		
		Tree tree = new Tree(parent, SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER );
		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 150;
		tree.setLayoutData(gridData);
			
		contentProvider = new HostsContentProvider();
		hostViewer = new TreeViewer(tree);
		hostViewer.setContentProvider(contentProvider);
		hostViewer.setLabelProvider(new HostsLabelProvider(true, fileImage));

		contentProvider.setFilter(HostsContentProvider.FILTER_FOLDERS);

		ViewerSorter sorter = new ViewerSorter()
		{
			public void sort(Viewer viewer, Object[] elements)
			{
				if(elements.length > 0)
					super.sort(viewer, elements);
			}
		
			public int category(Object element)
			{
				if(element instanceof IResource)
					return 0;

				return 10;
			}		
		};
		hostViewer.setSorter(sorter);
	
		return hostViewer;
	}
	
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		if (title != null)
			shell.setText(title);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e)
	{
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e)
	{
		if(e.widget == filterButton)						
		{
			contentProvider.setFilter((filterButton.getSelection() ? HostsContentProvider.SHOW_ALL : HostsContentProvider.FILTER_FOLDERS));
			ISelection selection = hostViewer.getSelection();				
			hostViewer.refresh();
			if(!selection.isEmpty())
				hostViewer.setSelection(selection, true);
		}
		
		if(e.widget == hostViewer.getControl())
		{
			setSelection();
		}
	}
	
	private void setSelection()
	{
		ISelection selection = hostViewer.getSelection();
		if(selection != null && !selection.isEmpty())
		{ 
			Iterator it = ((IStructuredSelection)selection).iterator();
			Vector objects = new Vector();
			while(it.hasNext())
			{
				Object element = it.next();
				if(element instanceof EObject)
					objects.add((EObject)element);
			}
			selectedEObjects = new EObject[objects.size()];
			for(int i = 0; i < objects.size(); i++)
				selectedEObjects[i] = (EObject)objects.get(i);
		}
	}
	
	public EObject[] getSelectedObjects()
	{
		if(selectedEObjects == null)
			selectedEObjects = new EObject[0];
					
		return this.selectedEObjects;
	}

	public IFile[] getSelectedFiles()
	{
		if(selectedEObjects == null)
			return new IFile[0];
			
		IFile[] selectedFiles = new IFile[selectedEObjects.length];
		for(int i = 0; i < selectedEObjects.length; i++)
			selectedFiles[i] = EMFUtil.getWorkspaceFile(selectedEObjects[i]);
			
		return selectedFiles;
	}
}
