/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ArtifactEditorPart.java,v 1.2 2005/02/25 22:17:54 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;

/**
 * Concrete implementation of IHyadesEditorPart customized for
 * handling Hyades objects stored in resources with file extension equals to 
 * {@link org.eclipse.hyades.models.common.util.ICommonConstants#ARTIFACT_FILE_EXTENSION}.
 * 
 * @author bjiang
 * @since  3.0
 */
public class ArtifactEditorPart extends BaseEditorPart 
{
	/**
	 * Default constructor.
	 */
	public ArtifactEditorPart() 
	{
		super(CFGArtifact.class);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.BaseEditorPart#identifyEditorDescriptor(org.eclipse.emf.ecore.EObject)
	 */
	protected IAssociationDescriptor identifyEditorDescriptor(EObject eObject) 
	{
		IAssociationMapping editorAssociationMapping = TestUIExtension.getArtifactMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS);
		return editorAssociationMapping.getDefaultAssociationDescriptor();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.editor.IHyadesEditorPart#getFileExtension()
	 */
	public String getFileExtension() 
	{
		return ICommonConstants.ARTIFACT_FILE_EXTENSION;
	}

}
