/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolEditorPart.java,v 1.9 2009/05/17 16:16:09 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.ui.texteditor.ITextEditorExtension2;


/**
 * <p>Concrete implementation of IHyadesEditorPart customized for
 * handling Hyades objects stored in resources with file extension equals to 
 * {@link org.eclipse.hyades.test.ui.TestUI#DATAPOOL_FILE_EXTENSION}.</p>
 * 
 * 
 * @author  Peter Sun
 * @author  Paul Slauenwhite
 * @author  Bianca Xue Jiang
 * @version May 16, 2009
 * @since   February 1, 2005
 */
public class DatapoolEditorPart extends BaseEditorPart implements ITextEditorExtension2
{
	
	/**
	 * Constructor for DeploymentEditorPart
	 */
	public DatapoolEditorPart()
	{
		super(DPLDatapool.class);
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IHyadesEditorPart#getFileExtension()
	 */
	public String getFileExtension()
	{
		return ICommonConstants.DATAPOOL_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.EMFEditorPart#identifyEditorDescriptor(org.eclipse.emf.ecore.EObject)
	 */
	protected IAssociationDescriptor identifyEditorDescriptor(EObject eObject)
	{
		IAssociationMapping editorAssociationMapping = TestUIExtension.getDatapoolMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS);
		return editorAssociationMapping.getDefaultAssociationDescriptor();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.editor.HyadesEditorPart#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapterClass) {
		if(adapterClass.equals(IFindReplaceTarget.class))
			return ((DatapoolEditorExtension)getEditorExtension()).getFindReplaceTarget();
		return super.getAdapter(adapterClass);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.texteditor.ITextEditorExtension2#isEditorInputModifiable()
	 * Required by datapool search capability.
	 */
	public boolean isEditorInputModifiable() {
		return !isReadOnly();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.texteditor.ITextEditorExtension2#validateEditorInputState()
	 * Required by datapool search capability.
	 */
	public boolean validateEditorInputState() {
		return true;
	}
}
