/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteEditorPart.java,v 1.2 2005/02/25 22:17:55 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;

/**
 * Concrete implementation of IHyadesEditorPart customized for
 * handling Hyades objects stored in resources with file extension equals to 
 * {@link org.eclipse.hyades.test.ui.TestUI#TEST_SUITE_FILE_EXTENSION}.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class TestSuiteEditorPart 
extends BaseEditorPart
{
	private String testSuiteType;
	
	/**
	 * Constructor for TestSuiteEditorPart
	 */
	public TestSuiteEditorPart()
	{
		super(TPFTestSuite.class);
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IHyadesEditorPart#getFileExtension()
	 */
	public String getFileExtension()
	{
		return ICommonConstants.TEST_SUITE_FILE_EXTENSION;
	}
	
	/**
	 * Returns the type of this editor's test suite.
	 * @return String
	 */
	public String getTestSuiteType()
	{
		return testSuiteType;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.EMFEditorPart#identifyEditorDescriptor(org.eclipse.emf.ecore.EObject)
	 */
	protected IAssociationDescriptor identifyEditorDescriptor(EObject eObject)
	{
		TPFTestSuite testSuite = (TPFTestSuite)eObject;
		testSuiteType = testSuite.getType();
		
		TestUIExtension.registerTestSuiteType(testSuiteType);
		IAssociationMapping editorAssociationMapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS);
		return editorAssociationMapping.getDefaultAssociationDescriptor(testSuiteType);
	}
}
