/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LocationEditorExtension.java,v 1.5 2006/02/01 15:48:16 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.Vector;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.LocationForm;

/**
 * Hyades configurable object editor extension that is suitable for all {@link CFGLocation} objects.
 * 
 * @author bjiang
 * @since	1.3
 */
public class LocationEditorExtension extends ConfigurableObjectEditorExtension 
{
	public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Location"; //$NON-NLS-1$
	public static final String EDITOR_OBJECT_TYPE = CFGLocation.class.getName(); // "org.eclipse.hyades.models.common.configuration.CFGLocation"
	
	protected IConfigurationElement[] collectPropertyGroupExtensions() 
	{
		IConfigurationElement[] extensions = super.collectPropertyGroupExtensions();		
		Vector registeredExts = new Vector();		 
		{
			for( int i = 0; i < extensions.length; i++ )
			{
			   if( extensions[i].getAttribute("appliesTo").equals(EDITOR_OBJECT_TYPE)) //$NON-NLS-1$
			   {
				   registeredExts.add( extensions[i] );
			   }
			}
		}	
		
		if( extensions.length == registeredExts.size() )
			return extensions;	
		
		IConfigurationElement[] registeredExtensions = new IConfigurationElement[registeredExts.size()];
		for( int i = 0; i < registeredExts.size(); i++ )
		{
			registeredExtensions[i] = (IConfigurationElement)registeredExts.get(i);
		}
		return registeredExtensions;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	protected ConfigurableObjectOverviewForm createOverviewPage(WidgetFactory widgetFactory)
	{
		return new LocationForm(this, widgetFactory);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.IExtensibleEditorExtension#activateExtensionPage(org.eclipse.core.runtime.IConfigurationElement)
	 */
	public int addExtensionPage(IConfigurationElement extensionElement) 
	{
		// if this extension element is not intended for location editor, return -1.
	   	if( !extensionElement.getAttribute("appliesTo").equals(EDITOR_OBJECT_TYPE)) //$NON-NLS-1$
		    return -1;
		    
		return super.addExtensionPage(extensionElement);
	}
}
