/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ArtifactForm.java,v 1.7 2010/04/06 16:35:34 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.RegisteredExtensionsSection;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.widgets.Composite;

/**
 * <p>Overview page of the Artifact editor.</p>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul Slauenwhite
 * @version April 6, 2010
 * @since   February 1, 2005
 */
public class ArtifactForm extends ConfigurableObjectOverviewForm
{
	private int assetsPageIndex;	
	private NamedElementsSection assetsSection;
	
	/**
	 * Constructor for ArtifactForm
	 * @param artifactEditorExtension
	 * @param widgetFactory
	 */
	public ArtifactForm(ConfigurableObjectEditorExtension artifactEditorExtension, WidgetFactory widgetFactory)
	{
		super(artifactEditorExtension, widgetFactory);
		setHeadingText(UiPluginResourceBundle.W_ARTIFACT); 
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		if(assetsSection != null)
		{
		    assetsSection.dispose();
		    assetsSection = null;
		}

		super.dispose();
	}
	
	/**
	 * Sets the index of the Test Assets tab that is presented when the "more" button
	 * of the Test Assets section is pressed. 
	 * @param index
	 */
	public void setTestAssetsPageIndex(int index)
	{
	    assetsPageIndex = index;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		super.createEditorFormContents(parent);	

		assetsSection = new NamedElementsSection(getBaseEditorExtension(), assetsPageIndex);
		registerSection(assetsSection);
		assetsSection.createControl(getRightColumnContainer(), factory, UiPluginResourceBundle.W_TEST_ASSETS, UiPluginResourceBundle.EDT_ART_AST_DSC);
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
	    super.load();
	    assetsSection.initialize(getDataObject(), Common_ConfigurationPackage.eINSTANCE.getCFGArtifact_DeployableInstances(), null);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm#createPropertyGroupExtensionsSection(org.eclipse.swt.widgets.Composite)
	 */
	protected RegisteredExtensionsSection createPropertyGroupExtensionsSection(Composite parent){
		
		RegisteredExtensionsSection registeredExtensionsSection = super.createPropertyGroupExtensionsSection(parent);
		
		if(registeredExtensionsSection != null){
			registeredExtensionsSection.setDescription(UiPluginResourceBundle.EDT_ART_PROP_GRP_DSC);
		}
		
		return registeredExtensionsSection;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm#createGeneralInfoSection(org.eclipse.swt.widgets.Composite)
	 */
	protected void createGeneralInfoSection(Composite parent) {

		super.createGeneralInfoSection(parent);
		
		getGeneralInfoSection().setDescription(UiPluginResourceBundle.EDT_ART_GENERAL_DSC);
	}
}
