/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonEventSection.java,v 1.8 2009/04/07 17:53:31 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;

/**
 * <p>CommonEventSection.java</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version April 7, 2009
 * @since   February 1, 2005
 */
public class CommonEventSection 
extends EditorSection implements IHyperlinkListener
{	 
	private StyledText timeText;
	private SelectableFormLabel modelElementLink;
	private StyledText messageText;
	
	private TPFExecutionEvent executionEvent;

	/**
	 * Constructor for NamedElementSection
	 * @param editorForm 
	 */
	public CommonEventSection(EditorForm editorForm)
	{
		super(editorForm);
		setCollapsable(true);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		executionEvent = null;
		super.dispose();
	}

	protected TPFExecutionEvent getExecutionEvent()
	{
		return executionEvent;
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.update.ui.forms.internal.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
				
		modelElementLink = widgetFactory.createSelectableLabel(composite, ""); //$NON-NLS-1$
		modelElementLink.setText(UiPluginResourceBundle.NO_INTF_TO_INV); 
		modelElementLink.setToolTipText(UiPluginResourceBundle.NO_INTF_TO_INV); 
		widgetFactory.turnIntoHyperlink(modelElementLink, this);

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_TIME); 
		timeText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		timeText.setLayoutData(GridDataUtil.createHorizontalFill());
		timeText.setEditable(false);

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_TEXT); 
		messageText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		GridData gridData = GridDataUtil.createHorizontalFill();
		gridData.heightHint = 4*messageText.getLineHeight();
		messageText.setLayoutData(gridData);
		messageText.setEditable(false);
								
		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		executionEvent = null;

		timeText.removeVerifyKeyListener(this);
		messageText.removeVerifyKeyListener(this);

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof TPFExecutionEvent)
		{
			executionEvent = (TPFExecutionEvent)object;
			
			timeText.setText(EventUtil.getTime(getExecutionEvent().getTimestamp()));
			
			String value = getExecutionEvent().getText();
			if(value != null)
				messageText.setText(value);
			else
				messageText.setText(""); //$NON-NLS-1$	
				
			TPFTest test = null;
			if((executionEvent.getExecutionHistory() != null) && (executionEvent.getExecutionHistory().getExecutionResult() != null))
				test = executionEvent.getExecutionHistory().getExecutionResult().getTest();

			BVRInteractionFragment interactionFragment = executionEvent.getInteractionFragment();
			if(interactionFragment != null)
			{
				if(interactionFragment.getName() != null){
					modelElementLink.setText(interactionFragment.getName());
					modelElementLink.setToolTipText(interactionFragment.getName());
				}
				else{
					modelElementLink.setText(UiPluginResourceBundle.W_ELEMENT);
					modelElementLink.setToolTipText(UiPluginResourceBundle.W_ELEMENT);
				}
					
				modelElementLink.setData(interactionFragment);
			}
			else if(test != null)
			{
				if(test.getName() != null){
					modelElementLink.setText(test.getName());
					modelElementLink.setToolTipText(test.getName());
				}
				else{
					modelElementLink.setText(UiPluginResourceBundle.W_TEST);
					modelElementLink.setToolTipText(UiPluginResourceBundle.W_TEST);
				}
					
				modelElementLink.setData(test);
			}
			else
			{
				modelElementLink.setText(UiPluginResourceBundle.NO_INTF_TO_INV);
				modelElementLink.setToolTipText(UiPluginResourceBundle.NO_INTF_TO_INV);
				modelElementLink.setData(null);
			}
		}
		else
		{
			timeText.setText(""); //$NON-NLS-1$
			messageText.setText(""); //$NON-NLS-1$
			modelElementLink.setText(UiPluginResourceBundle.NO_INTF_TO_INV); 
			modelElementLink.setToolTipText(UiPluginResourceBundle.NO_INTF_TO_INV);

			timeText.setEditable(false);
			messageText.setEditable(false);			
		}
		
		modelElementLink.pack(true);
		modelElementLink.redraw();
		
		timeText.addVerifyKeyListener(this);
		messageText.addVerifyKeyListener(this);
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getInput()
	 */
	public Object getInput()
	{
		return getExecutionEvent();
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getStructuredSelection()
	 */
	public IStructuredSelection getStructuredSelection()
	{
		if(getExecutionEvent() == null)
			return StructuredSelection.EMPTY;
		return new StructuredSelection(getExecutionEvent());
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{

	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkActivated(org.eclipse.swt.widgets.Control)
	 */
	public void linkActivated(Control linkLabel)
	{
		Object data = linkLabel.getData();
		if(data != null)
		{
			EObject eObject = (EObject)data;
			Resource resource = eObject.eResource();
			IEditorPart editorPart = TestUIUtil.openEditor(resource, null, false);
			if(editorPart instanceof ISelectionProvider)
				((ISelectionProvider)editorPart).setSelection(new StructuredSelection(eObject));
			
			return;
		}
		
		IActionBars actionBars = getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
			manager.setErrorMessage(UiPluginResourceBundle._ERROR_MSG_UN_OPEN_OBJ); 
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkEntered(org.eclipse.swt.widgets.Control)
	 */
	public void linkEntered(Control linkLabel)
	{
		IActionBars actionBars = getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
			manager.setMessage(((SelectableFormLabel)linkLabel).getText());
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkExited(org.eclipse.swt.widgets.Control)
	 */
	public void linkExited(Control linkLabel)
	{
		IActionBars actionBars = getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
		{
			manager.setMessage(""); //$NON-NLS-1$
			manager.setErrorMessage(""); //$NON-NLS-1$
		}
	}	
}