/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentForm.java,v 1.13 2010/04/06 16:35:34 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.extension.DeploymentEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DeploymentTestSuitesSection;
import org.eclipse.hyades.test.ui.internal.editor.util.DeploymentCompatibilityConverter;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/**
 * <p>Overview page of the Deployment editor.</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Bianca Xue Jiang
 * @author  Paul Slauenwhite
 * @version April 6, 2010
 * @since   February 1, 2005
 */
public class DeploymentForm extends ConfigurableObjectOverviewForm
{	
	private int mapPageIndex;	
	private NamedElementsSection artifactsSection;
	private NamedElementsSection locationsSection;
	private DeploymentTestSuitesSection testSuitesSection;

	
	/**
	 * Constructor for DeploymentForm
	 * @param deploymentEditorExtension
	 * @param widgetFactory
	 */
	public DeploymentForm(DeploymentEditorExtension deploymentEditorExtension, WidgetFactory widgetFactory)
	{
		super(deploymentEditorExtension, widgetFactory);
		setHeadingText(UiPluginResourceBundle.W_DEPLOYMENT); 
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		if(artifactsSection != null)
		{
			artifactsSection.dispose();
			artifactsSection = null;
		}
		if(locationsSection != null)
		{
			locationsSection.dispose();
			locationsSection = null;
		}
		if(testSuitesSection != null)
		{
		    testSuitesSection.dispose();
		    testSuitesSection = null;
		}

		super.dispose();
	}
	
	/**
	 * Sets the index of the Locations page that is presented when the "more" button
	 * of the location section is pressed. 
	 * @param index
	 */
	public void setLocationPageIndex(int index)
	{
		mapPageIndex = index;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(getControl(), UiPlugin.getID() + ContextIds.DEPL_FORM);
		return control;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		super.createEditorFormContents(parent);	
		
		IConfigurationElement[] propertyGroupExtensions = ((ConfigurableObjectEditorExtension)getBaseEditorExtension()).getPropertyGroupExtensions();
		if(propertyGroupExtensions != null && propertyGroupExtensions.length > 0)
			super.createPropertyGroupExtensionsSection(getLeftColumnContainer());
		
		artifactsSection = new NamedElementsSection(getBaseEditorExtension(), mapPageIndex);
		artifactsSection.setMoreButtonText(UiPluginResourceBundle.EDT_DEP_ART_LBL_MORE);
		registerSection(artifactsSection);
		artifactsSection.createControl(getRightColumnContainer(), factory, UiPluginResourceBundle.W_ARTIFACTS, UiPluginResourceBundle.EDT_DEP_ART_DSC);

		locationsSection = new NamedElementsSection(getBaseEditorExtension(), mapPageIndex);
		locationsSection.setMoreButtonText(UiPluginResourceBundle.EDT_DEP_LOC_LBL_MORE);
		registerSection(locationsSection);
		locationsSection.createControl(getRightColumnContainer(), factory,
			UiPluginResourceBundle.W_LOCS, 
			UiPluginResourceBundle.EDT_DEP_LOC_DSC); 
		
		testSuitesSection = new DeploymentTestSuitesSection();
		registerSection(testSuitesSection);
		testSuitesSection.createControl(getRightColumnContainer(), factory, UiPluginResourceBundle.W_TST_SUITE, UiPluginResourceBundle.EDT_DEP_TSUITE_DSC);
	}
	
	protected void setGeneralInfoSectionHelp(Control control)
	{
		//UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(((GeneralInfoSection)getGeneralInfoSection()).getFileText(), UiPlugin.getID() + ContextIds.DEPL_TEXT_FORM);
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(control, UiPlugin.getID() + ContextIds.DEPL_NAME_FORM);	
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		super.load();
		
		boolean isOld = false;
		TPFDeployment deployment = (TPFDeployment)getDataObject();
		artifactsSection.initialize(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), null);
		testSuitesSection.initialize(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), null);
		if(!deployment.getLocations().isEmpty())
		{
			boolean toConvert = MessageDialog.openQuestion(Display.getCurrent().getActiveShell(), 
															UiPluginResourceBundle.DLG_UPGRADE_DEP,  
															UiPluginResourceBundle.DLG_UPGRADE_DSC); 
			if(toConvert == true)
			{			
				try
				{
					DeploymentCompatibilityConverter.convert(deployment);
					getBaseEditorExtension().markDirty();
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}						   						
			}
			else
			{
				isOld = true;
			}
		}
		
		if(isOld)
			locationsSection.initialize(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Locations(), null);
		else		
			locationsSection.initialize(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations(), null);
	}
	
	public void openLocationEditor(CFGLocation location)
	{
		IFile file = EMFUtil.getWorkspaceFile(location);
		UIUtil.openEditor(file, TestUIExtension.LOCATION_EDITOR_PART_ID, false);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm#createGeneralInfoSection(org.eclipse.swt.widgets.Composite)
	 */
	protected void createGeneralInfoSection(Composite parent) {

		super.createGeneralInfoSection(parent);
		
		getGeneralInfoSection().setDescription(UiPluginResourceBundle.EDT_DEP_GENERAL_DSC);
	}
}
