/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventForm.java,v 1.10 2008/01/21 17:19:20 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;


import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ExecutionEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EventSection;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class EventForm
extends EditorForm implements ISelectionChangedListener
{
	private EObjectTreeSection eventSection;
	private CommonEventSection commonEventSection;
	private DetailSection eventDetailSection;
	private DetailSection executionResultDetailSection;
	private StyledText defaultText;
	
	private PageBook rightColumnPageBook; 
	
	private boolean firstActivation = true;
	
	/**
	 * Constructor for EventForm
	 * @param junitEditorExtension
	 * @param widgetFactory
	 */
	public EventForm(ExecutionEditorExtension executionEditorExtension, WidgetFactory widgetFactory)
	{
		super(executionEditorExtension, widgetFactory);
		setHeadingText(UiPluginResourceBundle.W_EXECUTION); 
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		eventSection.getTreeViewer().removeSelectionChangedListener(this);
		eventSection.dispose();
		commonEventSection.dispose();
		eventDetailSection.dispose();
		
		super.dispose();
	}

	/**
	 * Returns the test case suite manipulated by this form.
	 * @return TPFTestSuite
	 */
	protected TPFExecutionResult getExecution()
	{
		return ((ExecutionEditorExtension)getBaseEditorExtension()).getExecution();		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(parent, UiPlugin.getID() + ContextIds.EXEC_EDIT_EVENTS);

		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);
		
		eventSection = new EventSection(this, Common_TestprofilePackage.eINSTANCE.getTPFExecutionHistory_ExecutionEvents(), null);
		eventSection.setTreeStryle(SWT.FULL_SELECTION | SWT.SINGLE);
		registerSection(eventSection);
		eventSection.setHeaderText(UiPluginResourceBundle.W_EVENTS); 
		Control control = eventSection.createControl(leftColumn, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));		
		
		rightColumnPageBook = new PageBook(rightColumn, SWT.NONE);
		rightColumnPageBook.setLayoutData(GridDataUtil.createFill());
		rightColumnPageBook.setBackground(getWidgetFactory().getBackgroundColor());
		rightColumnPageBook.addMouseListener(new MouseAdapter()
		{
			public void mouseDown(MouseEvent e)
			{
				((Control) e.widget).setFocus();
			}
		});
		rightColumnPageBook.setMenu(parent.getMenu());

		Composite defaultControl = getWidgetFactory().createComposite(rightColumnPageBook);
		defaultControl.setLayout(new GridLayout());
		defaultControl.setLayoutData(GridDataUtil.createFill());
		getWidgetFactory().createLabel(defaultControl, ""); //$NON-NLS-1$
		defaultText = getWidgetFactory().createStyledText(defaultControl, SWT.FULL_SELECTION | SWT.SINGLE);
		defaultText.setLayoutData(GridDataUtil.createFill());
		//defaultText.setFont(JFaceResources.getBannerFont());
		defaultText.setEnabled(false);
		getWidgetFactory().paintBordersFor(defaultControl);
		
		Composite eventComposite = getWidgetFactory().createComposite(rightColumnPageBook);
		gridLayout = new GridLayout();
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		eventComposite.setLayout(gridLayout);		
		eventComposite.setLayoutData(GridDataUtil.createFill());

		commonEventSection = new CommonEventSection(this);
		commonEventSection.setHeaderText(UiPluginResourceBundle.TTL_CMN_PROPS); 
		registerSection(commonEventSection);		
		control = commonEventSection.createControl(eventComposite, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);
		
		eventDetailSection = new DetailSection(this);
		eventDetailSection.setDetailPageProvider(new ExecutionEventDetailPageProvider());
		eventDetailSection.setHeaderText(UiPluginResourceBundle.TTL_DTL_PROPS); 
		registerSection(eventDetailSection);
		control = eventDetailSection.createControl(eventComposite, getWidgetFactory());
		gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);

		executionResultDetailSection = new DetailSection(this);
		executionResultDetailSection.setDetailPageProvider(new ExecutionResultDetailPageProvider());
		executionResultDetailSection.setHeaderText(UiPluginResourceBundle.W_SUMMARY); 
		registerSection(executionResultDetailSection);
		control = executionResultDetailSection.createControl(rightColumnPageBook, getWidgetFactory());
		gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);
		
		rightColumnPageBook.showPage(eventComposite);
		((GridData)rightColumnPageBook.getLayoutData()).heightHint = eventComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT, true).y;			
	}
	
	public void revealSelect( Object element )
	{
		if ( eventSection != null )
		{
			StructuredSelection selection	= null;
			eventSection.getTreeViewer().reveal( element );
			selection = new StructuredSelection( element );
			eventSection.getTreeViewer().setSelection( selection );
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		updateDefaultText();
			
		eventSection.getTreeViewer().removeSelectionChangedListener(this);
		setInputPreservingExpandedElements();
		eventSection.getTreeViewer().addSelectionChangedListener(this);
	}
	
	protected void setInputPreservingExpandedElements()
	{
		Object[] expandedElements = eventSection.getTreeViewer().getExpandedElements();
		for (int i = 0, maxi = expandedElements.length; i < maxi; i++)
		{
			if(expandedElements[i] instanceof EObject)
				expandedElements[i] = EcoreUtil.getURI((EObject)expandedElements[i]);
		}
		eventSection.setInput(getExecution().getExecutionHistory());
		for (int i = 0, maxi = expandedElements.length; i < maxi; i++)
		{
			if(expandedElements[i] instanceof URI)
				expandedElements[i] = getExecution().eResource().getResourceSet().getEObject((URI)expandedElements[i], false);
		}
		try
		{
			eventSection.getTreeViewer().setExpandedElements(expandedElements);
		}
		catch(Exception e)
		{
		}
	}
	
	protected void updateDefaultText()
	{
		String text = null;
		
		if((getExecution() == null) || (getExecution().getExecutionHistory() == null) || (getExecution().getExecutionHistory().getExecutionEvents().isEmpty()))
			text = UiPluginResourceBundle.MSG_NO_EVE; 
		else
			text = UiPluginResourceBundle.MSG_NO_EVE_SEL; 
			
		defaultText.setText(text);
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		eventSection.selectReveal(selection);
	}
	
	/**
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event)
	{
		if(event.getSource() == eventSection.getTreeViewer())
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)getSelection();
			if(structuredSelection.size() == 1)
			{
				Object selection = structuredSelection.getFirstElement();
				if(selection instanceof TPFExecutionEvent)
				{
					commonEventSection.setInput(selection);
					if(eventDetailSection != null)
						eventDetailSection.setInput(selection);
					rightColumnPageBook.showPage(rightColumnPageBook.getChildren()[1]);
					return;
				}
				
				if(selection instanceof TPFExecutionResult)
				{
					executionResultDetailSection.setInput(selection);
					rightColumnPageBook.showPage(rightColumnPageBook.getChildren()[2]);
					return;
				}
			}
			
			updateDefaultText();
			rightColumnPageBook.showPage(rightColumnPageBook.getChildren()[0]);
		}
	}
	
	public ISelection getSelection()
	{
		return eventSection.getTreeViewer().getSelection();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		if(firstActivation)
		{
			firstActivation = false;
			eventSection.setFocus();
		}
			
		return super.activated();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#updateTitle()
	 */
	public void updateTitle()
	{
	}	
}
