/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionEventDetailPageProvider.java,v 1.6 2007/05/02 19:35:48 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFWaitEvent;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExecutionHistoryExtensionsManager;

/**
 * Provides DetailPage for input elements of type TPFExecutionEvent.
 * This provider is using the extension registry to look up for specific
 * detail pages associated the execution event's type. If no specific detail
 * page is associated to the type of execution event, or if the execution event
 * has no type, a default page is provided.
 * @author jcanches
 * @since 4.0
 * @deprecated use org.eclipse.hyades.test.ui.forms.base.ExecutionEventDetailsProvider instead
 */
public class ExecutionEventDetailPageProvider implements DetailSection.IDetailPageProvider {
	
	private HashMap classToDefaultPageMap = new HashMap();
	private HashMap typeToPageMap = new HashMap();
	private List typesWithNoExtension = new ArrayList();
	
	public ExecutionEventDetailPageProvider() {
		buildDefaultPageMap();
	}

	private void buildDefaultPageMap() {
		classToDefaultPageMap.put(TPFTypedEvent.class, new TypedEventDetailPage());
		classToDefaultPageMap.put(TPFMessageEvent.class, new MessageEventDetailPage());
		classToDefaultPageMap.put(TPFInvocationEvent.class, new InvocationEventDetailPage());
		classToDefaultPageMap.put(TPFVerdictEvent.class, new VerdictEventDetailPage());
		//added to support new loop event :BGB(12/1/03)
		classToDefaultPageMap.put(TPFLoopEvent.class, new LoopEventDetailPage());
		classToDefaultPageMap.put(TPFTimedEvent.class, new TimedEventDetailPage());
		classToDefaultPageMap.put(TPFWaitEvent.class, new TimedEventDetailPage());
	}
	
	private IDetailPage getExtensionPage(String eventType) {
		if (typesWithNoExtension.contains(eventType)) {
			// Optimization: we have already computed that there is no specific
			// page for this type.
			return null;
		}
		IDetailPage page = (IDetailPage) typeToPageMap.get(eventType);
		if (page == null) {
			// Find the provider for this type
			IDetailPageFactory provider = ExecutionHistoryExtensionsManager.getInstance().getEventDetailPageFactory(eventType);
			if (provider != null) {
				page = provider.createExecutionEventDetailPage(eventType);
			}
			if (page == null) {
				// Remember that no specific page is available for this type
				typesWithNoExtension.add(eventType);
			} else {
				// Let's cache this page so that we don't instantiate it again when
				// a page for the same type is requested.
				typeToPageMap.put(eventType, page);
			}
		}
		return page;
	}
	
	public IDetailPage getDetailPage(Object element) {
		IDetailPage page = null;
		if (element instanceof TPFExecutionEvent) {
			TPFExecutionEvent event = (TPFExecutionEvent)element;
			String type = event.getEventType();
			if (type != null && !"".equals(type)) {
				// This event has a type. Lookup for a specific page first.
				page = getExtensionPage(type);
			}
			if (page == null) {
				// Lookup for the default detail page, according to the event class
				Iterator it = classToDefaultPageMap.entrySet().iterator();
				while (it.hasNext()) {
					Map.Entry entry = (Map.Entry) it.next();
					if (((Class)entry.getKey()).isAssignableFrom(element.getClass())) {
						page = (IDetailPage)entry.getValue();
						break;
					}
				}
			}
		}
		return page;
	}
	
	public void dispose() {
		// Dispose the default pages
		Iterator it = classToDefaultPageMap.values().iterator();
		while (it.hasNext()) {
			IDetailPage page = (IDetailPage) it.next();
			page.dispose();
		}
		// Dispose the extension pages
		it = typeToPageMap.values().iterator();
		while (it.hasNext()) {
			IDetailPage page = (IDetailPage) it.next();
			page.dispose();
		}
	}
	
}