/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionResultDetailPageProvider.java,v 1.3 2006/01/30 09:19:55 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExecutionHistoryExtensionsManager;

/**
 * Provides DetailPage for input elements of type TPFExecutionResult.
 * This provider is using the extension registry to look up for specific
 * detail pages associated the execution result's type. If no specific detail
 * page is associated to the type of execution result, or if the execution result
 * has no type, a default page is provided.
 * @author jcanches
 * @since 4.0
 * @deprecated see org.eclipse.hyades.test.ui.forms.base.ExecutionEventDetailsProvider
 */
public class ExecutionResultDetailPageProvider implements DetailSection.IDetailPageProvider {
	
	private IDetailPage defaultDetailPage = new ExecutionResultDetailPage();
	private HashMap typeToPageMap = new HashMap();
	private List typesWithNoExtension = new ArrayList();
	
	private IDetailPage getExtensionPage(String resultType) {
		if (typesWithNoExtension.contains(resultType)) {
			// Optimization: we have already computed that there is no specific
			// page for this type.
			return null;
		}
		IDetailPage page = (IDetailPage) typeToPageMap.get(resultType);
		if (page == null) {
			// Find the provider for this type
			IDetailPageFactory provider = ExecutionHistoryExtensionsManager.getInstance().getResultDetailPageFactory(resultType);
			if (provider != null) {
				page = provider.createExecutionResultDetailPage(resultType);
			}
			if (page == null) {
				// Remember that that specific page is available for this type
				typesWithNoExtension.add(resultType);
			} else {
				// Let's cache this page so that we don't instantiate it again when
				// a page for the same type is requested.
				typeToPageMap.put(resultType, page);
			}
		}
		return page;
	}
	
	public IDetailPage getDetailPage(Object element) {
		IDetailPage page = null;
		if (element instanceof TPFExecutionResult) {
			TPFExecutionResult result = (TPFExecutionResult)element;
			String type = result.getType();
			if (type != null && !"".equals(type)) {
				// This result has a type. Lookup for a specific page first.
				page = getExtensionPage(type);
			}
			if (page == null) {
				page = defaultDetailPage;
			}
		}
		return page;
	}
	
	public void dispose() {
		defaultDetailPage.dispose();
		// Dispose the extension pages
		Iterator it = typeToPageMap.values().iterator();
		while (it.hasNext()) {
			IDetailPage page = (IDetailPage) it.next();
			page.dispose();
		}
	}
	
}