/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPropertyGroupForm.java,v 1.3 2005/09/22 16:25:34 jcanches Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ISetSelectionTarget;

/**
 * Interface of configuration editor forms that extension instances of Hyades extension point 
 * <i>org.eclipse.hyades.test.ui.configurationEditorForm</i> should implement.
 * 
 * @author bjiang
 * @since  1.3
 */
public interface IPropertyGroupForm extends ISetSelectionTarget
{
    /**
     * Sets the {@link org.eclipse.core.runtime.IConfigurationElement} object the instance of this
     * class is created for.
     * @param extension
     */
	public void setExtension(IConfigurationElement extension);
	
	public String getName();
	
	public String getDescription();
	
	/**
	 * Returns the {@link org.eclipse.hyades.models.common.configuration.CFGPropertyGroup} object this form is editing.
	 */
	public CFGPropertyGroup getPropertyGroup();
	
	/**
	 * Initializes the property group form.
	 * @since 4.1
	 */
	public void init(CFGPropertyGroup group, BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory);
	
	/**
	 * Creates the control of this form.
	 * @return Control
	 */
	public Control createControl();
	
	/**
	 * Subclasses should load the persited values to the controls in this method.  
	 * The goal is to provide a common behavior for the editor forms.
	 */
	public void load();
	
	/**
	 * Returns the specific selected object in this form.
	 * @return IStructuredSelection
	 */
	public IStructuredSelection getSelection();

	/**
	 * Sets the selection in this form to be revealed when the form is activated.  This method
	 * is called from the configurable object overview page, when a hyper-link representing one of the 
	 * properties of this property group is activated to bring this form on top.
	 * 
	 * @param selection the selction should be revealed. 
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection);

}
