/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InvocationEventDetailPage.java,v 1.8 2007/03/22 14:42:06 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * @deprecated replaced by eclipse forms based Test Log Viewer in 4.1.
 * @see org.eclipse.hyades.test.ui.forms.base.InvocationEventDetailsPart
 * @author marcelop
 * @since 0.3.0
 */
public class InvocationEventDetailPage extends AbstractDetailPage
{
	private StyledText statusText;
	private StyledText reasonText;

	private TPFInvocationEvent invocationEvent;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		invocationEvent = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.AbstractDetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context)
	{
		this.context = context;
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		//changed LBL_VERD to LBL_STATUS because invocation events do not have a verdict :BGB(12/2/03)
		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_STATUS); 
		statusText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		statusText.setLayoutData(GridDataUtil.createHorizontalFill());
		statusText.setEditable(false);

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_REASON); 
		reasonText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		reasonText.setLayoutData(GridDataUtil.createHorizontalFill());
		reasonText.setEditable(false);

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		invocationEvent = null;

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean objectIsSet = false;
		if(object instanceof TPFInvocationEvent)
		{
			invocationEvent = (TPFInvocationEvent)object;
			if(invocationEvent != null)
			{		
				objectIsSet = true;
				
				if(invocationEvent.getStatus() != null)
					statusText.setText(invocationEvent.getStatus().getLabel());
				else
					statusText.setText(""); //$NON-NLS-1$

				if(invocationEvent.getReason() != null)
					reasonText.setText(invocationEvent.getReason().getLabel());
				else
					reasonText.setText(""); //$NON-NLS-1$
			}						
		}
		
		if(!objectIsSet)
		{
			statusText.setText(""); //$NON-NLS-1$
			reasonText.setText(""); //$NON-NLS-1$
			statusText.setEditable(false);
			reasonText.setEditable(false);
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return invocationEvent;
	}
}
