/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LocationForm.java,v 1.10 2010/04/07 17:38:01 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.GeneralInfoSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NodeGeneralInfoSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.RegisteredExtensionsSection;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * <p>Overview page of the Location editor.</p>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul Slauenwhite
 * @version April 6, 2010
 * @since   February 1, 2005
 */
public class LocationForm extends ConfigurableObjectOverviewForm 
{
	/**
	 * Constructor for LocationOverviewForm
	 * @param locationEditorExtension
	 * @param widgetFactory
	 */
	public LocationForm(ConfigurableObjectEditorExtension locationEditorExtension, WidgetFactory widgetFactory)
	{
		super(locationEditorExtension, widgetFactory);
		setHeadingText(UiPluginResourceBundle.W_LOCATION); 
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(getControl(), UiPlugin.getID() + ContextIds.LOC_FORM);
		return control;
	}
	
	protected void createGeneralInfoSection(Composite parent) 
	{
		GeneralInfoSection generalInfoSection = new NodeGeneralInfoSection(this, true);
		generalInfoSection.setDescription(UiPluginResourceBundle.EDT_LOC_GENERAL_DSC); 
		generalInfoSection.setEditable(true);
		registerSection(generalInfoSection);		
		Control control = generalInfoSection.createControl(parent, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);		
		setGeneralInfoSectionHelp(control);
		setGeneralInfoSection(generalInfoSection);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm#createPropertyGroupExtensionsSection(org.eclipse.swt.widgets.Composite)
	 */
	protected RegisteredExtensionsSection createPropertyGroupExtensionsSection(Composite parent){
		
		RegisteredExtensionsSection registeredExtensionsSection = super.createPropertyGroupExtensionsSection(parent);
		
		if(registeredExtensionsSection != null){
			registeredExtensionsSection.setDescription(UiPluginResourceBundle.EDT_LOC_PROP_GRP_DSC);
		}
		
		return registeredExtensionsSection;
	}
}
