/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoopEventDetailPage.java,v 1.8 2007/03/22 14:42:07 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

import java.lang.Long;

/**
 * @deprecated replaced by eclipse forms based Test Log Viewer in 4.1.
 * @see org.eclipse.hyades.test.ui.forms.base.LoopEventDetailsPart
 * @author battersb
 * @since 0.3.0
 */
public class LoopEventDetailPage 
extends AbstractDetailPage
{
	private StyledText asynchronousText;
	private StyledText iterationsText;

	private TPFLoopEvent loopEvent;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		loopEvent = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.AbstractDetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context)
	{
		this.context = context;
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_ASYNCHRONOUS); 
		asynchronousText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		asynchronousText.setLayoutData(GridDataUtil.createHorizontalFill());
		asynchronousText.setEditable(false);

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_ITERATIONS); 
		iterationsText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		iterationsText.setLayoutData(GridDataUtil.createHorizontalFill());
		iterationsText.setEditable(false);

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		loopEvent = null;

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean objectIsSet = false;
		if(object instanceof TPFLoopEvent)
		{
			loopEvent = (TPFLoopEvent)object;
			if(loopEvent != null)
			{		
				objectIsSet = true;
				
				if(loopEvent.isAsynchronous() == true)
					asynchronousText.setText("True");
				else if(loopEvent.isAsynchronous() == false)
					asynchronousText.setText("False");

				Long	tempLong	= null;
				tempLong	= new Long( loopEvent.getIterations() );
				iterationsText.setText(tempLong.toString());
			}						
		}
		
		if(!objectIsSet)
		{
			asynchronousText.setText(""); //$NON-NLS-1$
			iterationsText.setText(""); //$NON-NLS-1$
			asynchronousText.setEditable(false);
			iterationsText.setEditable(false);
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return loopEvent;
	}
}
