/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MachineDetailPage.java,v 1.7 2008/01/21 17:19:20 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class MachineDetailPage extends AbstractDetailPage implements ModifyListener
{
	private StyledText hostNameText;
	private CFGMachineConstraint machine;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		machine = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.AbstractDetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context)
	{
		this.context = context;
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_HOST_NME); 
		hostNameText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		hostNameText.setLayoutData(GridDataUtil.createHorizontalFill());
		hostNameText.addVerifyKeyListener(this);
		
		widgetFactory.paintBordersFor(composite);

		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(hostNameText, UiPlugin.getID() + ContextIds.MACHINE_TEXT_PAGE);										
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(composite, UiPlugin.getID() + ContextIds.MACHINE_DET_PAGE);								
		
		return composite;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		machine = null;

		hostNameText.removeVerifyKeyListener(this);
		hostNameText.removeModifyListener(this);

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof CFGMachineConstraint)
		{
			machine = (CFGMachineConstraint)object;
			
			String value = machine.getHostname();
			if(value != null)
				hostNameText.setText(value);
			else
				hostNameText.setText(""); //$NON-NLS-1$

			hostNameText.setEditable(true);			
		}
		else
		{
			hostNameText.setText(""); //$NON-NLS-1$
		}
		
		hostNameText.addVerifyKeyListener(this);
		hostNameText.addModifyListener(this);
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return machine;
	}

	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		if(e.widget == hostNameText)
		{
			machine.setHostname(hostNameText.getText());
			getEditorForm().getBaseEditorExtension().markDirty();
		}
	}
}
