/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MessageEventDetailPage.java,v 1.8 2007/03/22 14:42:07 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

/**
 * @deprecated replaced by eclipse forms based Test Log Viewer in 4.1.
 * @see org.eclipse.hyades.test.ui.forms.base.MessageEventDetailsPart
 * @author marcelop
 * @since 0.3.0
 */
public class MessageEventDetailPage 
extends AbstractDetailPage
{
	private StyledText severityText;

	private TPFMessageEvent messageEvent;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		messageEvent = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.AbstractDetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context)
	{
		this.context = context;
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_SEV); 
		severityText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		severityText.setLayoutData(GridDataUtil.createHorizontalFill());
		severityText.setEditable(false);

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		messageEvent = null;

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean objectIsSet = false;
		if(object instanceof TPFMessageEvent)
		{
			messageEvent = (TPFMessageEvent)object;
			if((messageEvent != null) && (messageEvent.getSeverity() != null))
			{		
				objectIsSet = true;
				severityText.setText(messageEvent.getSeverity().getLabel());
			}						
		}
		
		if(!objectIsSet)
		{
			severityText.setText(""); //$NON-NLS-1$
			severityText.setEditable(false);
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return messageEvent;
	}
}
