/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimedEventDetailPage.java,v 1.8 2007/03/22 14:42:06 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * @deprecated replaced by eclipse forms based Test Log Viewer in 4.1.
 * @see org.eclipse.hyades.test.ui.forms.base.TimedEventDetailsPart
 * @author jtoomey
 * @since 3.0.1
 */
public class TimedEventDetailPage extends AbstractDetailPage
{
	private StyledText endTime;
	private StyledText duration;

	private TPFTimedEvent timedEvent;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		timedEvent = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.AbstractDetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context)
	{
		this.context = context;
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_END_TIME); 
		endTime = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		endTime.setLayoutData(GridDataUtil.createHorizontalFill());
		endTime.setEditable(false);

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_DURATION); 
		duration = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		duration.setLayoutData(GridDataUtil.createHorizontalFill());
		duration.setEditable(false);

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		timedEvent = null;

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean objectIsSet = false;
		if(object instanceof TPFTimedEvent)
		{
			timedEvent = (TPFTimedEvent)object;
			if(timedEvent != null)
			{		
				objectIsSet = true;
				endTime.setText(EventUtil.getTime(timedEvent.getEndTimestamp()));
				duration.setText(EventUtil.getDuration(timedEvent.getTimestamp(), timedEvent.getEndTimestamp()));
			}						
		}
		
		if(!objectIsSet)
		{
			endTime.setText(""); //$NON-NLS-1$
			duration.setText(""); //$NON-NLS-1$
			endTime.setEditable(false);
			duration.setEditable(false);
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return timedEvent;
	}
}
