/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: VerdictEventDetailPage.java,v 1.12 2007/05/03 01:51:56 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.core.util.JavaUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/**
 * @deprecated replaced by eclipse forms based Test Log Viewer in 4.1.
 * @see org.eclipse.hyades.test.ui.forms.base.VerdictEventDetailsPart
 * @author marcelop
 * @since 0.3.0
 */
public class VerdictEventDetailPage extends AbstractDetailPage implements IHyperlinkListener
{
	private final static String STACK_FRAME_PATTERN = "at "; //$NON-NLS-1$

	
	private StyledText verdictText;
	private StyledText reasonText;
	private SelectableFormLabel firstCausedByErrorLink;
	private Table stackTrace;
	private Composite stackGroup;

	private TPFVerdictEvent verdictEvent;

	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		verdictEvent = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.AbstractDetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context)
	{
		this.context = context;
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_VERD); 
		verdictText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		verdictText.setLayoutData(GridDataUtil.createHorizontalFill());
		verdictText.setEditable(false);

		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_REASON); 
		reasonText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		reasonText.setLayoutData(GridDataUtil.createHorizontalFill());
		reasonText.setEditable(false);
		
		stackGroup = widgetFactory.createComposite(composite);
		GridLayout gl = new GridLayout();
		//gl.horizontalSpacing = 0;
		gl.marginWidth = 1;
		stackGroup.setLayout(gl);
		stackGroup.setLayoutData(GridDataUtil.createFill());
		
		widgetFactory.createLabel(stackGroup, UiPluginResourceBundle.LBL_FAILURE_TRACE); 
		stackTrace = widgetFactory.createTable(stackGroup, SWT.SINGLE);
		GridData data = GridDataUtil.createFill();
		data.heightHint = stackTrace.getItemHeight() * 8;
		stackTrace.setLayoutData(data);
		OpenStrategy handler = new OpenStrategy(stackTrace);
		handler.addOpenListener(new IOpenEventListener() {
			public void handleOpen(SelectionEvent e) {
				if (stackTrace.getSelection().length != 0) {
					openStackFrame(getStackTraceSelectedText());
				}
			}
		});
		widgetFactory.paintBordersFor(stackGroup);
		
		firstCausedByErrorLink = widgetFactory.createSelectableLabel(composite, ""); //$NON-NLS-1$
		firstCausedByErrorLink.setText(UiPluginResourceBundle.W_FIRSTCAUSELINK); 
		firstCausedByErrorLink.setToolTipText(UiPluginResourceBundle.TIP_CAUSE_LINK); 
		widgetFactory.turnIntoHyperlink(firstCausedByErrorLink, this);
		firstCausedByErrorLink.setVisible( false );
		
		composite.layout();
		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	private String getStackTraceSelectedText() {
		return stackTrace.getSelection()[0].getText();
	}				

	private void openStackFrame(String traceLine) {
		try { 
			String testName= traceLine;
			testName= testName.substring(testName.indexOf(STACK_FRAME_PATTERN)); //$NON-NLS-1$
			testName= testName.substring(STACK_FRAME_PATTERN.length(), testName.lastIndexOf('(')).trim();
			testName= testName.substring(0, testName.lastIndexOf('.'));
			int innerSeparatorIndex= testName.indexOf('$');
			if (innerSeparatorIndex != -1)
				testName= testName.substring(0, innerSeparatorIndex);
			
			String lineNumber= traceLine;
			lineNumber= lineNumber.substring(lineNumber.indexOf(':') + 1, lineNumber.lastIndexOf(')'));
			int line= Integer.valueOf(lineNumber).intValue();
			String cuName= traceLine.substring(traceLine.lastIndexOf('(') + 1, traceLine.lastIndexOf(':'));
			openCompilationUnitAtLine(cuName, testName, line);
		} catch(NumberFormatException e) {
			// Problem in parsing line: don't do anything
		}
		catch(IndexOutOfBoundsException e) {	
			// Ditto
		}
		catch(CoreException e) {
			// Problem when opening the editor
			UiPlugin.logError(e);
		}
	}
	
	private void openCompilationUnitAtLine(String cuName, String className, int line) throws CoreException {
		IJavaElement javaElement = JavaUtil.findElement(getJavaProject(), cuName, className);
		if (javaElement != null) {
			org.eclipse.hyades.ui.internal.util.JavaUtil.revealJavaElementAtLine(javaElement, line);
		}
	}

	private IJavaProject getJavaProject() {
		if (verdictEvent != null) {
			IFile file = EMFUtil.getWorkspaceFile(verdictEvent);
			if (file != null) {
				return JavaCore.create(file.getProject());
			}
		}
		return null;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		verdictEvent = null;

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean objectIsSet = false;
		if(object instanceof TPFVerdictEvent)
		{
			verdictEvent = (TPFVerdictEvent)object;
			if(verdictEvent != null)
			{		
				objectIsSet = true;
				
				if(verdictEvent.getVerdict() != null)
					verdictText.setText(verdictEvent.getVerdict().getLabel());
				else
					verdictText.setText(""); //$NON-NLS-1$

				if(verdictEvent.getReason() != null)
					reasonText.setText(verdictEvent.getReason().getLabel());
				else
					reasonText.setText(""); //$NON-NLS-1$
				//added following code to support cause aggregation :BGB(12/02/03)
				if ( ( verdictEvent.getCausedBy() != null ) &&
				     ( verdictEvent.getCausedBy().isEmpty() == false ) )
				{
					if ( firstCausedByErrorLink != null )
					{
						firstCausedByErrorLink.setVisible( true );
						firstCausedByErrorLink.setData( verdictEvent.getCausedBy() );
					}
				}
				else
				{
					if ( firstCausedByErrorLink != null )
						firstCausedByErrorLink.setVisible( false );
				}
				
				setStackTraceInput(verdictEvent);
			}						
		}
		
		if(!objectIsSet)
		{
			verdictText.setText(""); //$NON-NLS-1$
			reasonText.setText(""); //$NON-NLS-1$
			verdictText.setEditable(false);
			reasonText.setEditable(false);
			if ( firstCausedByErrorLink != null )
				firstCausedByErrorLink.setVisible( false );
			setStackTraceInput(null);
		}
	}

	private void addStackItem(String text, boolean isException) {
		TableItem item = new TableItem(stackTrace, SWT.NONE);
		item.setText(text.trim());
		if (isException) {
			item.setImage(TestUIImages.INSTANCE.getImage(TestUIImages.IMG_STACK_FRAME));
		} else {
			item.setImage(TestUIImages.INSTANCE.getImage(TestUIImages.IMG_CATCH_CLAUSE));
		}
	}
	
	private void setStackTraceInput(TPFVerdictEvent event) {
		stackTrace.removeAll();
		stackGroup.setVisible(false);
		if (event == null) return;
		String trace = event.getText();
		if (trace == null) return;
		int end = trace.indexOf(STACK_FRAME_PATTERN);
		if (end == -1) {
			addStackItem(trace, false);
		} else {
			addStackItem(trace.substring(0, end), false);
		}
		while (end != -1) {
			int start = end;
			end = trace.indexOf(STACK_FRAME_PATTERN, start + STACK_FRAME_PATTERN.length());
			if (end == -1) {
				addStackItem(trace.substring(start), true);
			} else {
				addStackItem(trace.substring(start, end), true);
			}
		}
		stackGroup.setVisible(true);
	}
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return verdictEvent;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkActivated(org.eclipse.swt.widgets.Control)
	 */
	public void linkActivated(Control linkLabel)
	{
		Object 	data 			= linkLabel.getData(),
				verdictObj		= null;
		EList	verdictCauses	= null;	
		
		if ( data instanceof EList )
		{
			verdictCauses	= (EList)data;
			verdictObj		= verdictCauses.get( 0 );
			EditorForm editorForm = getEditorForm();
			if (editorForm != null && editorForm instanceof EventForm)
			{
				((EventForm)editorForm).revealSelect( verdictObj );
			}
		}
		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkEntered(org.eclipse.swt.widgets.Control)
	 */
	public void linkEntered(Control linkLabel)
	{
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkExited(org.eclipse.swt.widgets.Control)
	 */
	public void linkExited(Control linkLabel)
	{
	}
}
