/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILayoutExtension.java,v 1.2 2005/02/25 22:17:55 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.swt.widgets.Composite;

/**
 * Classes that extend abstract class Layout and implement
 * this interface can take part in layout computation of
 * the HTMLTableLayout manager. The said layout uses
 * alternative algorithm that computes columns before rows.
 * It allows it to 'flow' wrapped text proportionally
 * (as in the popular web browsers). Custom layout managers
 * that implement this interface allow recursive reflow
 * to be performed.
 */
public interface ILayoutExtension {
	public int getMinimumWidth(Composite parent, boolean changed);
	public int getMaximumWidth(Composite parent, boolean changed); 
}
