/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ModifiedTextCellEditor.java,v 1.2 2005/02/25 22:17:55 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/**
 * @author marcelop
 * @since 
 */
public class ModifiedTextCellEditor extends TextCellEditor
{
	public ModifiedTextCellEditor(Composite parent)
	{
		super(parent);
		setValueValid(true);
	}

	protected void doSetValue(Object object)
	{
		// Workaround for 32926
		if (object == null)
			object = ""; //$NON-NLS-1$
		super.doSetValue(object);
	}
	public Control createControl(Composite parent)
	{
		Text text = (Text)super.createControl(parent);

		text.addListener(SWT.Traverse, new Listener()
		{
			public void handleEvent(Event e)
			{
				// do whatever it is you want to do on commit
				handleEnter();
				// this will prevent the return from 
				// traversing to the button
				e.doit = false;
			}
		});
		return text;
	}

	public void forceCommit()
	{
		if (isDirty())
			fireApplyEditorValue();
	}

	protected void handleEnter()
	{
		fireApplyEditorValue();
	}
}