/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SharedPart.java,v 1.3 2005/08/19 21:13:30 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * @author marcelop
 * @since 0.2.0
 */
public abstract class SharedPart
{
	private boolean enabled = true;

	public void setEnabled(boolean enabled)
	{
		if (enabled != this.enabled)
		{
			this.enabled = enabled;
			updateEnabledState();
		}
	}

	public abstract void createControl(Composite parent, int style, int span, FormWidgetFactory factory);

	public boolean isEnabled()
	{
		return enabled;
	}

	protected void updateEnabledState()
	{
	}

	
	protected Composite createComposite(Composite parent, FormWidgetFactory factory)
	{
		return createComposite(parent, (Object) factory);
	}
	
	protected Composite createComposite(Composite parent, FormToolkit factory)
	{
		return createComposite(parent, (Object) factory);
	}
	
	
	
	/**
	 * A helper method created here to avoid repeated statements.  This method will
	 * need to be taken off and its content transfered to 
	 * Composite createComposite(Composite parent, FormToolkit factory) once 
	 * Composite createComposite(Composite parent, FormWidgetFactory factory) is 
	 * taken off
	 */
	private Composite createComposite(Composite parent, Object factory)
	{
		
		if (factory == null)
			return new Composite(parent, SWT.NULL);
		
		return (factory instanceof FormToolkit ? ((FormToolkit)factory).createComposite(parent) : ((FormWidgetFactory)factory).createComposite(parent));
	}

	protected Label createEmptySpace(Composite parent, int span, FormWidgetFactory factory)
	{
		return createEmptySpace (parent, span, (Object)factory);
	}
	
	
	protected Label createEmptySpace(Composite parent, int span, FormToolkit factory)
	{
		return createEmptySpace (parent, span, (Object)factory);
	}
	
	
	/**
	 * A helper method created here to avoid repeated statements.  This method will
	 * need to be taken off and its content transfered to 
	 * createEmptySpace(Composite parent, int span, FormToolkit factory) once 
	 * createEmptySpace(Composite parent, int span, FormWidgetFactory factory) is 
	 * taken off
	 */
	private Label createEmptySpace (Composite parent, int span, Object factory)
	{
		boolean isToolkit = false;
		if (factory instanceof FormToolkit)
			isToolkit = true;
		
		
		Label label;
		if (factory != null)
		{
			label = (isToolkit ? ((FormToolkit)factory).createLabel(parent, null) : ((FormWidgetFactory)factory).createLabel(parent, null));
		}
		else
		{
			label = new Label(parent, SWT.NULL);
		}
		GridData gd = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = span;
		gd.widthHint = 0;
		gd.heightHint = 0;
		label.setLayoutData(gd);
		
		return label;
	}
}
