/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StructuredViewerPart.java,v 1.5 2005/08/19 21:17:03 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * @author marcelop
 * @since 0.2.0
 */
public abstract class StructuredViewerPart 
extends SharedPartWithButtons
{
	private StructuredViewer viewer;
	private Point minSize = null;
	
	/* A key listener for t he delete butotn */
	private KeyListener deleteListener;

	public StructuredViewerPart(String[] buttonLabels)
	{
		super(buttonLabels);
	}
    
    public StructuredViewerPart(String[] buttonLabels,String[] toolTips)
    {
        super(buttonLabels,toolTips);
    }

	public StructuredViewer getViewer()
	{
		return viewer;
	}

	public Control getControl()
	{
		return viewer.getControl();
	}

	protected void createMainControl(Composite parent, int style, int span, FormWidgetFactory factory)
	{
		createMainControl(parent, style, span, (Object)factory);
		Control control = viewer.getControl();
		if (factory != null)
		{
			factory.hookDeleteListener(control);
		}
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = span;
		control.setLayoutData(gd);
		applyMinimumSize();
	}

	
	/*
	 * @see SharedPartWithButtons#createMainControl(Composite, int, FormToolkit)
	 */
	protected void createMainControl(Composite parent, int style, int span, FormToolkit factory)
	{
		createMainControl(parent, style, span, (Object)factory);
		Control control = viewer.getControl();
		if (deleteListener == null) {
			deleteListener = new KeyAdapter() {
				public void keyPressed(KeyEvent event) {
					if (event.character == SWT.DEL && event.stateMask == 0) {
						if (!(event.widget instanceof Control))
							return;
						Control control = (Control) event.widget;
						for (Control parent = control.getParent(); parent != null; parent = parent.getParent()) 
						{
							// TODO: ALI M.: This needs to be fixed.
							if (parent.getData() instanceof FormSection) 
							{
								FormSection section = (FormSection) parent.getData();
								section.doGlobalAction(ActionFactory.DELETE.getId());
								break;
							}
						}
					}
				}
			};
		}
		control.addKeyListener(deleteListener);

		GridData gd = new GridData(SWT.FILL,SWT.FILL,true,true);
		gd.horizontalSpan = span;
		control.setLayoutData(gd);
		applyMinimumSize();
	}
	
	
	/**
	 * A helper method to avoid repeated statments.  Transfer content and take this method out once the 
	 * deprecated version of createMainControl is taken out.
	 */
	private void createMainControl(Composite parent, int style, int span, Object factory)
	{
		viewer = (factory instanceof FormToolkit ? createStructuredViewer(parent, style, (FormToolkit) factory) : createStructuredViewer(parent, style, (FormWidgetFactory) factory));
		viewer.addSelectionChangedListener(new ISelectionChangedListener()
		{
			public void selectionChanged(SelectionChangedEvent e)
			{
				StructuredViewerPart.this.selectionChanged((IStructuredSelection)e.getSelection());
			}
		});
		viewer.addDoubleClickListener(new IDoubleClickListener()
		{
			public void doubleClick(DoubleClickEvent e)
			{
			    StructuredViewerPart.this.handleDoubleClick((IStructuredSelection)e.getSelection());
			}
		});
	}
	
	public void setMinimumSize(int width, int height)
	{
		minSize = new Point(width, height);
		if (viewer != null)
			applyMinimumSize();
	}
	private void applyMinimumSize()
	{
		if (minSize != null)
		{
			GridData gd = (GridData)viewer.getControl().getLayoutData();
			gd.widthHint = minSize.x;
			gd.heightHint = minSize.y;
		}
	}

	protected void updateEnabledState()
	{
		getControl().setEnabled(isEnabled());
		super.updateEnabledState();
	}


	protected abstract StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory);
	
	
	/**
	 * This method should be made abstract after its deprecated version is deleted
	 */
	protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit factory)
	{
		return null;
	}
	
	protected void selectionChanged(IStructuredSelection selection)
	{
	}
	protected void handleDoubleClick(IStructuredSelection selection)
	{
	}
}
