/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TablePart.java,v 1.3 2005/08/19 21:17:47 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TablePart extends StructuredViewerPart
{

	/**
	 * Constructor for TablePart.
	 * @param buttonLabels
	 */
	public TablePart(String[] buttonLabels)
	{
		super(buttonLabels);
	}

	protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory)
	{
		return createStructuredViewer(parent, style, (Object) factory);
	}
	
	/*
	 * @see StructuredViewerPart#createStructuredViewer(Composite, FormWidgetFactory)
	 */
	protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit factory)
	{
		return createStructuredViewer(parent, style, (Object) factory);
	}
	
	/*
	 * @see StructuredViewerPart#createStructuredViewer(Composite, FormWidgetFactory)
	 */
	private StructuredViewer createStructuredViewer(Composite parent, int style, Object factory)
	{
		style |= SWT.H_SCROLL | SWT.V_SCROLL;
		if (factory == null)
		{
			style |= SWT.BORDER;
		}
		else
		{
			style |= FormWidgetFactory.BORDER_STYLE;
		}
		TableViewer tableViewer = new TableViewer(parent, style);
		tableViewer.addSelectionChangedListener(new ISelectionChangedListener()
		{
			public void selectionChanged(SelectionChangedEvent e)
			{
				TablePart.this.selectionChanged((IStructuredSelection)e.getSelection());
			}
		});
		tableViewer.addDoubleClickListener(new IDoubleClickListener()
		{
			public void doubleClick(DoubleClickEvent e)
			{
				TablePart.this.handleDoubleClick((IStructuredSelection)e.getSelection());
			}
		});
		return tableViewer;
	}

	public TableViewer getTableViewer()
	{
		return (TableViewer)getViewer();
	}
	/*
	 * @see SharedPartWithButtons#buttonSelected(int)
	 */
	protected void buttonSelected(Button button, int index)
	{
	}

	protected void selectionChanged(IStructuredSelection selection)
	{
	}
	protected void handleDoubleClick(IStructuredSelection selection)
	{
	}

}
