/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: DetailsPageProvider.java,v 1.4 2007/05/02 19:35:49 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailPropertiesSection.IDetailFormProvider;
import org.eclipse.hyades.ui.util.IDisposable;


public class DetailsPageProvider implements IDetailFormProvider {

	private HashMap typeToPageMap = new HashMap();
	
	/**
	 * Records an association between a given java type and a detail page.
	 * This provider will return the detail page for any input element that is
	 * of type objectClass.
	 * @param objectClass A java type.
	 * @param detailPage A Detail Page. This detail page is owned by the provider, ie 
	 * it will be disposed by the provider when the provider is disposed.
	 */
	public void addDetailPage(Class objectClass, IDetailForm detailPage) {
		typeToPageMap.put(objectClass, detailPage);
	}
	
	public IDetailForm getDetailPage(Object element) {
		Iterator it = typeToPageMap.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry entry = (Map.Entry) it.next();
			if (((Class)entry.getKey()).isAssignableFrom(element.getClass())) {
				return (IDetailForm)entry.getValue();
			}
		}
		return null;
	}
	
	/**
	 * Returns whether no association have been registered.
	 * @return
	 */
	public boolean isEmpty() {
		return typeToPageMap.isEmpty();
	}
	
	public void dispose() {
		Iterator it = typeToPageMap.values().iterator();
		while (it.hasNext()) 
		{
			Object nextObject = it.next();
			if (nextObject instanceof IDisposable)
			{
				IDisposable page = (IDisposable) nextObject;
				page.dispose();
			}
			
		}
	}

}
