/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectTree.java,v 1.5 2007/04/26 18:50:09 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.Hashtable;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TreePart;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenDownAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenUpAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.DrillDownAdapter;


/**
 * This class was created in response to the deprecated APIs about the way that
 * forms are currently handled.
 * 
 * <p>
 * A Tree object
 * </p>
 * 
 * @author Ali Mehregani & marcelop
 */
public class EObjectTree extends GeneralStructureViewer
{

	protected class PartAdapter
	extends TreePart
	{
		public PartAdapter(String[] buttonLabels)
		{
			super(buttonLabels);
		}
        public PartAdapter(String[] buttonLabels,String[] toolTips)
        {
            super(buttonLabels,toolTips);
        }
		public void selectionChanged(IStructuredSelection selection)
		{
			EObjectTree.this.selectionChanged(selection);
		}
		public void handleDoubleClick(IStructuredSelection selection)
		{
			EObjectTree.this.handleDoubleClick(selection);
		}
		public void buttonSelected(Button button, int index)
		{
			/* If the index exceeds the standard button length, then it must be a custom button */
			if (index >= getStandardButtonLength())
			{
				Object buttonHandlerObj = customButtonHandler.get(new Integer(index));
				if (buttonHandlerObj != null)
				{
					((PrimitiveButtonHandler)buttonHandlerObj).buttonSelected(button);
				}				
			}	
			else
			{
				EObjectTree.this.buttonSelected(index);
			}
			
			if(isHandlingDefaultButton())
				button.getShell().setDefaultButton(null);					
		}
	}
	
	
	private EStructuralFeature eStructuralFeature;
	
	protected DrillDownAdapter drillDownAdapter;
	protected CollapseAllAction collapseAllAction;
	
	protected IAction addAction;
    protected IAction insertAction;
	protected RemoveChildrenAction removeAction;
	protected MoveChildrenUpAction moveUpAction;
	protected MoveChildrenDownAction moveDownAction;
	private Separator workbenchAdditionsGroup;
	
	private TreeViewer treeViewer;
	
	/* The style of the tree */
	private int treeStryle = SWT.FULL_SELECTION | SWT.MULTI;

	/* Custom button handlers */
	private Hashtable customButtonHandler;

	/* Holds the indices of the standard buttons */
	private int[] buttonIndices;
	
	/**
	 * Constructor for EObjectTreeSection
	 * @param editorForm
	 * @param buttonLabels
	 */
	public EObjectTree(IEditorExtension editorPart, EStructuralFeature eStructuralFeature, IAction addAction)
	{		
		super (editorPart);
		this.eStructuralFeature = eStructuralFeature;
		this.addAction = addAction;
		this.workbenchAdditionsGroup = new Separator(IWorkbenchActionConstants.MB_ADDITIONS);
		
		/* The default tree style */
		this.treeStryle = SWT.FULL_SELECTION | SWT.MULTI;
		
		String name = null;
		if(addAction != null)
			name = addAction.getText();
		adjustButtonLabels(name);		
	}
	

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		eStructuralFeature = null;
		
		if(drillDownAdapter != null)
		{
			getTreeViewer().removeSelectionChangedListener(drillDownAdapter);
			drillDownAdapter = null;
		}
		
		if(collapseAllAction != null)
		{
			collapseAllAction.dispose();
			collapseAllAction = null;
		}
		if(removeAction != null)
		{
			removeAction.dispose();
			removeAction = null;
		}
		if(moveUpAction != null)
		{
			moveUpAction.dispose();
			moveUpAction = null;
		}
		if(moveDownAction != null)
		{
			moveDownAction.dispose();
			moveDownAction = null;
		}
		if (customButtonHandler != null)
		{
			customButtonHandler.clear();
			customButtonHandler = null;
		}
		
		workbenchAdditionsGroup.dispose();
		addAction = null;
        insertAction = null;
	}
	
	protected EStructuralFeature getEStructuralFeature()
	{
		return eStructuralFeature;
	}
		
	
	public void addButton (PrimitiveButtonHandler buttonHandler, String buttonLabel, String buttonToolTip, int index)
	{
		viewerPart.addButton(buttonLabel, buttonToolTip, index);
		
		boolean isButtonHandlerNotNull = buttonHandler != null;
		if (customButtonHandler == null && isButtonHandlerNotNull)
			customButtonHandler = new Hashtable();
		if (isButtonHandlerNotNull)
			customButtonHandler.put (new Integer (viewerPart.getButtonLength() - 1), buttonHandler);
	}
	
	protected void adjustButtonLabels(String addLabel)
	{
		removeAction = new RemoveChildrenAction(false);
		moveUpAction = new MoveChildrenUpAction();
		moveDownAction = new MoveChildrenDownAction();
				
		setButtonLabels(new String[]{addLabel, removeAction.getText(), moveUpAction.getText(), moveDownAction.getText()});		
	}

    protected void adjustButtonLabels(String addLabel, String insertLabel)
    {
        removeAction = new RemoveChildrenAction(false);
        moveUpAction = new MoveChildrenUpAction();
        moveDownAction = new MoveChildrenDownAction();
                
        setButtonLabels(
        		new String[]{	addLabel, 
        						insertLabel, 
        						removeAction.getText(), 
        						moveUpAction.getText(), 
        						moveDownAction.getText()
        					},
        		new String[]{	UiPluginResourceBundle.TOOLTIP_ADD,
        						UiPluginResourceBundle.TOOLTIP_INSERT,
        						UiPluginResourceBundle.TOOLTIP_REMOVE,
        						UiPluginResourceBundle.TOOLTIP_UP,
        						UiPluginResourceBundle.TOOLTIP_DOWN
        					}
        		);         //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$ //$NON-NLS-5$
    }

	/**
	 * This method allows the add action to be added after the constructor time so there 
	 * won't be any button for it.
	 * @param addAction
	 */
	protected void setAddAction(IAction addAction)
	{
		this.addAction = addAction;
	}
    
    /**
     * @param insertAction The insertAction to set.
     */
    protected void setInsertAction(IAction insertAction) {
        this.insertAction = insertAction;
    }

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseTreeSection#adjustClient(org.eclipse.swt.widgets.Composite)
	 */
	protected void adjustClient(Composite parent)
	{
		getTreeViewer().setContentProvider(createContentProvider());
		getTreeViewer().setLabelProvider(createLabelProvider());
		getTreeViewer().setAutoExpandLevel(0);

		if(addAction != null)
			viewerPart.setButtonEnabled(0, addAction.isEnabled());
        
        if(insertAction != null)
        	viewerPart.setButtonEnabled(1, insertAction.isEnabled());
		
		if(moveDownAction != null)
			moveDownAction.setStructuredViewer(getTreeViewer());
		if(moveUpAction != null)
			moveUpAction.setStructuredViewer(getTreeViewer());
		if(removeAction != null)
			removeAction.setStructuredViewer(getTreeViewer());
	}
	
	/**
	 * Creates this section's content provider
	 * @return IContentProvider
	 */
	protected IContentProvider createContentProvider()
	{
		return new EObjectTreeContentProvider(editorPart, getEStructuralFeature());
	}

	/**
	 * Creates this section's label provider
	 * @return ILabelProvider
	 */
	protected ILabelProvider createLabelProvider()
	{
		return new WorkbenchAdapterLabelProvider(TestWorkbenchAdapter.class);
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#createActions()
	 */
	protected void createActions()
	{
		collapseAllAction = new CollapseAllAction(getTreeViewer()).useDefaultDecorators();
		
		drillDownAdapter = new DrillDownAdapter(getTreeViewer());
		getTreeViewer().addSelectionChangedListener(drillDownAdapter);

		if(removeAction != null)
			removeAction.setEnabled(false);

		if(moveDownAction != null)
		{
			moveDownAction.setEStructuralFeature(getEStructuralFeature());
			moveDownAction.setEnabled(false);
		}		

		if(moveUpAction != null)
		{
			moveUpAction.setEStructuralFeature(getEStructuralFeature());
			moveUpAction.setEnabled(false);
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#buttonSelected(int)
	 */
	protected void buttonSelected(int index)
	{
		if(!editorPart.getHyadesEditorPart().isReadOnly())
		{
			switch(index)
			{
				case 0:
					doAdd();
					break;
	
				case 1:
					doRemove();
					break;
	
				case 2:
					doMoveUp();
					break;
	
				case 3:
					doMoveDown();
					break;				
			}
		}
		
		updateActionsAndButtons((IStructuredSelection)viewerPart.getViewer().getSelection());
	}


	protected void doAdd()
	{
		if(addAction != null)
			addAction.run();
	}
    
    protected void doInsert()
    {
        if(insertAction != null)
            insertAction.run();
    }

	protected void doRemove()
	{
		if(removeAction != null)
			removeAction.run();
	}

	protected void doMoveUp()
	{
		if(moveUpAction != null)
			moveUpAction.run();
	}

	protected void doMoveDown()
	{
		if(moveDownAction != null)
			moveDownAction.run();
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#doGlobalAction(java.lang.String)
	 */
	public boolean doGlobalAction(String actionId)
	{
		if (actionId.equals(ActionFactory.DELETE.getId()))
		{
			if(removeAction != null)
				removeAction.run();
			return true;
		}
		return false;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	protected void fillContextMenu(IMenuManager menuManager)
	{
		if(removeAction != null)
		{
			if(removeAction.isEnabled())
				removeAction.setEnabled(!editorPart.getHyadesEditorPart().isReadOnly());
			menuManager.add(removeAction);
			menuManager.add(new Separator());
		}
		
		boolean enableCollapse = false;
		TreeItem[] treeItems = getTreeViewer().getTree().getItems();
		for (int i = 0, maxi = treeItems.length; i < maxi; i++)
		{
			if(treeItems[i].getExpanded())
			{
				enableCollapse = true;
				break;
			}
		}	
		
		if(enableCollapse)
		{
			menuManager.add(collapseAllAction);
			menuManager.add(new Separator());
		}
		
		menuManager.add(workbenchAdditionsGroup);

		// TODO: ALI M.: This needs to be fixed
//		if((getStructuredSelection().size() == 1) && (((ITreeContentProvider)getTreeViewer().getContentProvider())).hasChildren(getStructuredSelection().getFirstElement()))
//		{
//			drillDownAdapter.addNavigationActions(menuManager);
//		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#updateActionsAndButtons(org.eclipse.jface.viewers.IStructuredSelection)
	 */	
	protected void updateActionsAndButtons(IStructuredSelection structuredSelection)
	{
		if(addAction != null)
		{
			if(addAction instanceof SelectionListenerAction)
				((SelectionListenerAction)addAction).selectionChanged(structuredSelection);
			viewerPart.setButtonEnabled(buttonIndices[0], addAction.isEnabled());
		}
        
		if(removeAction != null)
		{
			removeAction.selectionChanged(structuredSelection);
			viewerPart.setButtonEnabled(buttonIndices[1], removeAction.isEnabled());
		}
		
		if(moveDownAction != null)
		{
			moveDownAction.selectionChanged(structuredSelection);
			viewerPart.setButtonEnabled(buttonIndices[3], moveDownAction.isEnabled());
		}
		
		if(moveUpAction != null)
		{
			moveUpAction.selectionChanged(structuredSelection);
			viewerPart.setButtonEnabled(buttonIndices[2], moveUpAction.isEnabled());
		}			
		
	}
	

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.StructuredViewerSection#createViewerPart(java.lang.String[])
	 */
	protected StructuredViewerPart createViewerPart(String[] buttonLabels)
	{
		return new PartAdapter(buttonLabels);
	}
	
    protected StructuredViewerPart createViewerPart(String[] buttonLabels, String[] toolTips) 
    {
        return new PartAdapter(buttonLabels,toolTips);  
    }
    
    
    /**
     * Invoked when creating the controls of this tree object 
     * 
     * @param parent The parent composite
     * @param toolkit The form toolkit used to create the controls
     */
	public Composite createControls(Composite parent, FormToolkit toolkit)
	{
		Composite container = toolkit.createComposite(parent);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginWidth = layout.marginHeight = 2;
		container.setLayout(layout);
		
		createViewerPartControl(container, getTreeStryle(), 2, toolkit);
		getTreeViewer().setAutoExpandLevel(AbstractTreeViewer.ALL_LEVELS);
		getTreeViewer().getControl().setFocus();

		adjustClient(parent);

		toolkit.paintBordersFor(container);
		
		return container;				
	}
	
	public TreeViewer getTreeViewer()
	{
		if (treeViewer == null)
			treeViewer = ((TreeViewer)viewerPart.getViewer());
		return treeViewer;
	}
	
	



	public int getTreeStryle()
	{
		return treeStryle;
	}


	public void setTreeStryle(int treeStryle)
	{
		this.treeStryle = treeStryle;
	}


    public StructuredViewerPart getViewerPart() {
		return viewerPart;
	}
    
    public interface PrimitiveButtonHandler
    {
    	public void buttonSelected(Button button);
    }
    
    
    /**
     * The selection of the tree displaying the test cases have changed.
     */
    protected void selectionChanged(IStructuredSelection structuredSelection)
	{
    	super.selectionChanged(structuredSelection);
    	updateActionsAndButtons(structuredSelection);
    	
	}
    
    public void setButtonIndices (int[] buttonIndices)
    {
    	this.buttonIndices = buttonIndices;
    }


	public int[] getButtonIndices() 
	{
		return buttonIndices;
	}
}
