/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EditorEclipseForm.java,v 1.6 2007/05/02 19:35:49 paules Exp $
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;


/**
 * Created in response to the deprecation of EditorForm.  This provides an
 * extended number of APIs required by the test suite forms.
 * 
 * @author Ali Mehregani
 */
abstract public class EditorEclipseForm extends FormPage 
{
	
	/* The editor that this form is apart of */
	private IEditorExtension formEditor;
	
	/* The title of the editor */
    private String editorTitle;

	/**
	 * The constructor
	 * 
	 * @param editorTitle The title of the editor
	 * @param editor The form editor that this form is apart of
	 * @param id The id of the form
	 * @param title The title of the form
	 */
	public EditorEclipseForm(IEditorExtension editor, String editorTitle, String id, String title) 
	{
		super((FormEditor)editor.getHyadesEditorPart(), id, title);
		formEditor = editor;	
		this.editorTitle = editorTitle;		
	}
	
	
	/**
	 * Creates a composite that corresponds to the a column in the given parent.
	 * 
	 * @param parent The parent composite
	 * @return Composite The column composite
	 */
	protected Composite createColumn(Composite parent)
	{
		FormToolkit toolKit = ((FormEditor)formEditor.getHyadesEditorPart()).getToolkit();
		Composite column = toolKit.createComposite(parent);
		
		GridLayout gridLayout = new GridLayout();
		gridLayout.verticalSpacing = 10;
		gridLayout.marginHeight = 10;
		gridLayout.marginWidth = 0;
		column.setLayout(gridLayout);
		
		GridData gd = GridDataUtil.createFill();
		column.setLayoutData(gd);
		
		return column;
	}
	
	
	/**
	 * Invoked when the form is activated.
	 * Usually over-written by clients.
	 * 
	 * @return Whether this form is activated
	 */
	public boolean activated()
	{
		return false;
	}
	
	/**
	 * Updates this editor form title.
	 * 
	 * Usually over-written by clients.
	 */
	public void updateTitle()
	{
	}
	
	
	/**
	 * Returns the test case suite manipulated by this form.
	 * 
	 * @return The model that we modified
	 */
	protected ITestSuite getCommonTestSuite()
	{
		return (TPFTestSuite) (formEditor.getHyadesEditorPart()).getEditorObject();
	}
	
	
	/**
	 * A method that is used to derive a standard template for each
	 * of the pages of the test suite editor.  Clients are of course
	 * not obligated to follow this template.
	 * 
	 * @param managedFrom Used to manage this form
	 */
	protected void createFormContent(IManagedForm managedForm)
	{
		ScrolledForm form = managedForm.getForm();
		form.setText(editorTitle);
		Composite parent = form.getBody();
		
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;		
		parent.setLayout(gridLayout);
		GridData gd = GridDataUtil.createFill();
		parent.setLayoutData(gd);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);
		
		createLeftColumnControls(leftColumn);
		createRightColumnControls(rightColumn);
	}


	/**
	 * The right column controls of the page are created by this method
	 * 
	 * @param parent The parent composite
	 */
	abstract protected void createRightColumnControls(Composite parent);
	
	
	/**
	 * The left column controls of the page are created by this method
	 * 
	 * @param parent The parent composite
	 */
	abstract protected void createLeftColumnControls(Composite parent);

	

	/**
	 * Returns the form editor that this form is apart of
	 * 
	 * @return The form editor. 
	 */
    public IEditorExtension getFormEditor() 
    {
		return formEditor;
	}
    
    
    /**
     * Clients have the option of implementing a details section in 
     * their forms.
     */
    protected void addDetails(DetailsPageProvider detailProvider)
    {
    	
    }
    
    /**
     * Returns the editor title.
     * 
     * @return The editor title
     */
    public String getEditorTitle()
    {
    	return editorTitle;
    }
    
    
    /**
     * Marks the editor dirty.
     */
	protected void markEditorDirty()
	{
		if (formEditor instanceof BaseEditorExtension)
			((BaseEditorExtension)formEditor).markDirty();
	}
    
    
    protected ScrolledForm getForm()
    {
    	if (getManagedForm() != null)
    		return getManagedForm().getForm();
    	return null;
    }
  
}
